/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.codestory.http.Context;
import net.codestory.http.io.ClasspathScanner;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.WebJarUrlFinder;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebJarsRoute
implements Route {
    private static final Logger LOG = LoggerFactory.getLogger(WebJarsRoute.class);
    private final boolean prodMode;
    private final WebJarUrlFinder webJarUrlFinder;

    public WebJarsRoute(boolean prodMode) {
        this.prodMode = prodMode;
        this.webJarUrlFinder = new WebJarUrlFinder(prodMode);
    }

    @Override
    public boolean matchUri(String uri) {
        if (uri.startsWith("/webjars/") && !uri.endsWith("/") && WebJarsRoute.getResource(uri) != null) {
            return true;
        }
        if (!this.prodMode && uri.contains("webjar") && uri.endsWith("/")) {
            this.printKnownWebjars();
        }
        return false;
    }

    private void printKnownWebjars() {
        LOG.info("Found these webjars files:");
        for (String uri : new ClasspathScanner().getResources(Paths.get("META-INF/resources/webjars/", new String[0]))) {
            LOG.info(" + " + Strings.substringAfter(uri, "META-INF/resources"));
        }
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Payload body(Context context) throws IOException {
        String uri = context.uri();
        URL classpathUrl = this.webJarUrlFinder.url(uri);
        try (InputStream stream = classpathUrl.openStream();){
            String contentType = ContentTypes.get(Paths.get(uri, new String[0]));
            byte[] data = InputStreams.readBytes(stream);
            Payload payload = new Payload(contentType, data).withHeader("Cache-Control", "public, max-age=31536000").withHeader("Last-Modified", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now().minusMonths(1L))).withHeader("Expires", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now().plusWeeks(1L)));
            return payload;
        }
    }

    private static URL getResource(String uri) {
        return Resources.getResource("META-INF/resources" + uri);
    }
}

