/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Supplier;
import net.codestory.http.Configuration;
import net.codestory.http.Context;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.annotations.Delete;
import net.codestory.http.annotations.Get;
import net.codestory.http.annotations.Head;
import net.codestory.http.annotations.Options;
import net.codestory.http.annotations.Post;
import net.codestory.http.annotations.Prefix;
import net.codestory.http.annotations.Put;
import net.codestory.http.extensions.ContextFactory;
import net.codestory.http.extensions.PayloadWriterFactory;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.injection.Singletons;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.ForEach;
import net.codestory.http.misc.UrlConcat;
import net.codestory.http.payload.Payload;
import net.codestory.http.payload.PayloadWriter;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.routes.CatchAllRoute;
import net.codestory.http.routes.FourParamsRoute;
import net.codestory.http.routes.NoParamRoute;
import net.codestory.http.routes.NoParamRouteWithContext;
import net.codestory.http.routes.OneParamRoute;
import net.codestory.http.routes.ReflectionRoute;
import net.codestory.http.routes.Route;
import net.codestory.http.routes.RouteWrapper;
import net.codestory.http.routes.Routes;
import net.codestory.http.routes.RoutesWithPattern;
import net.codestory.http.routes.SourceMapRoute;
import net.codestory.http.routes.StaticRoute;
import net.codestory.http.routes.ThreeParamsRoute;
import net.codestory.http.routes.TwoParamsRoute;
import net.codestory.http.routes.UriParser;
import net.codestory.http.routes.WebJarsRoute;
import net.codestory.http.templating.Site;

public class RouteCollection
implements Routes {
    private final Env env;
    private final Site site = new Site();
    private final Deque<Route> routes;
    private final Deque<Supplier<Filter>> filters;
    private IocAdapter iocAdapter;
    private ContextFactory contextFactory;
    private PayloadWriterFactory payloadWriterFactory;

    public RouteCollection() {
        this.env = new Env();
        this.routes = new LinkedList<Route>();
        this.filters = new LinkedList<Supplier<Filter>>();
        this.iocAdapter = new Singletons();
        this.contextFactory = (request, response) -> new Context(request, response, this.iocAdapter);
        this.payloadWriterFactory = (request, response) -> new PayloadWriter(this.env, this.site, request, response);
    }

    @Override
    public RouteCollection setIocAdapter(IocAdapter iocAdapter) {
        this.iocAdapter = iocAdapter;
        return this;
    }

    @Override
    public Routes setContextFactory(ContextFactory contextFactory) {
        this.contextFactory = contextFactory;
        return this;
    }

    @Override
    public Routes setPayloadWriterFactory(PayloadWriterFactory payloadWriterFactory) {
        this.payloadWriterFactory = payloadWriterFactory;
        return this;
    }

    @Override
    public RouteCollection include(Class<? extends Configuration> configurationClass) {
        this.iocAdapter.get(configurationClass).configure(this);
        return this;
    }

    @Override
    public RouteCollection include(Configuration configuration) {
        configuration.configure(this);
        return this;
    }

    @Override
    public RouteCollection filter(Class<? extends Filter> filterClass) {
        this.filters.addFirst(() -> (Filter)this.iocAdapter.get(filterClass));
        return this;
    }

    @Override
    public RouteCollection filter(Filter filter) {
        this.filters.addFirst(() -> filter);
        return this;
    }

    @Override
    public RouteCollection add(Class<?> resourceType) {
        this.addResource("", resourceType, () -> this.iocAdapter.get(resourceType));
        return this;
    }

    @Override
    public RouteCollection add(String urlPrefix, Class<?> resourceType) {
        this.addResource(urlPrefix, resourceType, () -> this.iocAdapter.get(resourceType));
        return this;
    }

    @Override
    public RouteCollection add(Object resource) {
        this.addResource("", resource.getClass(), () -> resource);
        return this;
    }

    @Override
    public RouteCollection add(String urlPrefix, Object resource) {
        this.addResource(urlPrefix, resource.getClass(), () -> resource);
        return this;
    }

    private void addResource(String urlPrefix, Class<?> type, Supplier<Object> resource) {
        Prefix prefixAnnotation;
        if (type.getName().contains("EnhancerByMockito")) {
            type = type.getSuperclass();
        }
        String classPrefix = (prefixAnnotation = type.getAnnotation(Prefix.class)) != null ? prefixAnnotation.value() : "";
        for (Method method : type.getMethods()) {
            ForEach.forEach(method.getAnnotationsByType(Get.class)).then(get -> this.addResource("GET", method, resource, RouteCollection.url(urlPrefix, classPrefix, get.value())));
            ForEach.forEach(method.getAnnotationsByType(Post.class)).then(post -> this.addResource("POST", method, resource, RouteCollection.url(urlPrefix, classPrefix, post.value())));
            ForEach.forEach(method.getAnnotationsByType(Put.class)).then(put -> this.addResource("PUT", method, resource, RouteCollection.url(urlPrefix, classPrefix, put.value())));
            ForEach.forEach(method.getAnnotationsByType(Delete.class)).then(delete -> this.addResource("DELETE", method, resource, RouteCollection.url(urlPrefix, classPrefix, delete.value())));
            ForEach.forEach(method.getAnnotationsByType(Head.class)).then(head -> this.addResource("HEAD", method, resource, RouteCollection.url(urlPrefix, classPrefix, head.value())));
            ForEach.forEach(method.getAnnotationsByType(Options.class)).then(opts -> this.addResource("OPTIONS", method, resource, RouteCollection.url(urlPrefix, classPrefix, opts.value())));
        }
    }

    static String url(String resourcePrefix, String classPrefix, String uri) {
        return new UrlConcat().url(resourcePrefix, classPrefix, uri);
    }

    private void addResource(String httpMethod, Method method, Supplier<Object> resource, String uriPattern) {
        int uriParamsCount;
        int methodParamsCount = method.getParameterCount();
        if (methodParamsCount < (uriParamsCount = UriParser.paramsCount(uriPattern))) {
            throw new IllegalArgumentException("Expected at least" + uriParamsCount + " parameters in " + uriPattern);
        }
        this.add(httpMethod, uriPattern, new ReflectionRoute(resource, method));
    }

    @Override
    public RouteCollection get(String uriPattern, Object payload) {
        this.get(uriPattern, () -> payload);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, NoParamRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, NoParamRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, OneParamRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, TwoParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, ThreeParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, FourParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, Object payload) {
        this.options(uriPattern, () -> payload);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, NoParamRoute route) {
        this.add("OPTIONS", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, NoParamRouteWithContext route) {
        this.add("OPTIONS", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, OneParamRoute route) {
        this.add("OPTIONS", RouteCollection.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, TwoParamsRoute route) {
        this.add("OPTIONS", RouteCollection.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, ThreeParamsRoute route) {
        this.add("OPTIONS", RouteCollection.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, FourParamsRoute route) {
        this.add("OPTIONS", RouteCollection.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, Object payload) {
        this.head(uriPattern, () -> payload);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, NoParamRoute route) {
        this.add("HEAD", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, NoParamRouteWithContext route) {
        this.add("HEAD", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, OneParamRoute route) {
        this.add("HEAD", RouteCollection.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, TwoParamsRoute route) {
        this.add("HEAD", RouteCollection.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, ThreeParamsRoute route) {
        this.add("HEAD", RouteCollection.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, FourParamsRoute route) {
        this.add("HEAD", RouteCollection.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, NoParamRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, NoParamRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, OneParamRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, TwoParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, ThreeParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, FourParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, NoParamRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, NoParamRouteWithContext route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, OneParamRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, TwoParamsRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, ThreeParamsRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, FourParamsRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, NoParamRoute route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, NoParamRouteWithContext route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, OneParamRoute route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, TwoParamsRoute route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, ThreeParamsRoute route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, FourParamsRoute route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection catchAll(Object payload) {
        this.catchAll(() -> payload);
        return this;
    }

    @Override
    public RouteCollection catchAll(NoParamRoute route) {
        this.routes.add(new CatchAllRoute(route));
        return this;
    }

    @Override
    public RouteCollection catchAll(NoParamRouteWithContext route) {
        this.routes.add(new CatchAllRoute(route));
        return this;
    }

    @Override
    public RoutesWithPattern with(String uriPattern) {
        return new RoutesWithPattern(this, uriPattern);
    }

    private RouteCollection add(String method, String uriPattern, AnyRoute route) {
        this.routes.add(new RouteWrapper(method, uriPattern, route));
        return this;
    }

    public void addStaticRoutes(boolean prodMode) {
        this.routes.add(new WebJarsRoute(prodMode));
        this.routes.add(new StaticRoute(prodMode));
        this.routes.add(new SourceMapRoute());
    }

    public Payload apply(Context context) throws IOException {
        String uri = context.uri();
        if (uri == null) {
            return Payload.notFound();
        }
        PayloadSupplier payloadSupplier = () -> {
            Payload response = Payload.notFound();
            for (Route route : this.routes) {
                if (route.matchUri(uri)) {
                    if (route.matchMethod(context.method())) {
                        return route.apply(uri, context);
                    }
                    response = Payload.methodNotAllowed();
                    continue;
                }
                if (uri.endsWith("/") || !route.matchUri(uri + '/')) continue;
                if (route.matchMethod(context.method())) {
                    return Payload.seeOther(uri + '/');
                }
                response = Payload.methodNotAllowed();
            }
            return response;
        };
        for (Supplier<Filter> filter : this.filters) {
            if (!filter.get().matches(uri, context)) continue;
            PayloadSupplier nextFilter = payloadSupplier;
            payloadSupplier = () -> ((Filter)filter.get()).apply(uri, context, nextFilter);
        }
        return payloadSupplier.get();
    }

    public Context createContext(Request request, Response response) {
        return this.contextFactory.create(request, response);
    }

    public PayloadWriter createPayloadWriter(Request request, Response response) {
        return this.payloadWriterFactory.create(request, response);
    }

    private static String checkParametersCount(String uriPattern, int count) {
        if (UriParser.paramsCount(uriPattern) != count) {
            String error = count == 1 ? "1 parameter" : count + " parameters";
            throw new IllegalArgumentException("Expected " + error + " in " + uriPattern);
        }
        return uriPattern;
    }
}

