/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import java.util.concurrent.atomic.AtomicBoolean;
import net.codestory.http.Configuration;
import net.codestory.http.io.Resources;
import net.codestory.http.reload.FolderWatcher;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReloadingRoutesProvider
implements RoutesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadingRoutesProvider.class);
    private final Configuration configuration;
    private final AtomicBoolean dirty;
    private final FolderWatcher classesWatcher;
    private final FolderWatcher appWatcher;
    private RouteCollection routes;

    ReloadingRoutesProvider(Configuration configuration) {
        this.configuration = configuration;
        this.dirty = new AtomicBoolean(true);
        this.classesWatcher = new FolderWatcher(Resources.classesOutputPath(), ev -> this.dirty.set(true));
        this.appWatcher = new FolderWatcher(Resources.appPath(), ev -> this.dirty.set(true));
    }

    @Override
    public synchronized RouteCollection get() {
        if (this.dirty.get()) {
            LOG.info("Reloading configuration...");
            this.classesWatcher.ensureStarted();
            this.appWatcher.ensureStarted();
            this.routes = new RouteCollection();
            this.configuration.configure(this.routes);
            this.routes.addStaticRoutes(false);
            this.dirty.set(false);
        }
        return this.routes;
    }
}

