/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.nio.file.Path;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.compilers.PathSource;

public class LessSourceMapCompiler
implements Compiler {
    @Override
    public String compile(Path path, String source) {
        try {
            return new ThreadUnsafeLessCompiler().compile((LessSource)new PathSource(path, source)).getSourceMap();
        }
        catch (Less4jException e) {
            String message = LessSourceMapCompiler.cleanMessage(path, e.getMessage());
            throw new CompilerException(message);
        }
    }

    private static String cleanMessage(Path path, String message) {
        return "Unable to compile less " + path + ": " + message.replace("Could not compile less. ", "");
    }
}

