/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.codestory.http.compilers.SourceFile;
import net.codestory.http.io.Strings;
import net.codestory.http.templating.YamlParser;

public class YamlFrontMatter {
    private static final Pattern FRONT_MATTER = Pattern.compile("\\A\\s*(?:---\\r?\\n((?:(?!---).)*)---\\s*\\r?\\n)?(.*)\\z", 32);
    private final Path path;
    private final String content;
    private final Map<String, Object> variables;

    private YamlFrontMatter(Path path, String content, Map<String, Object> variables) {
        this.path = path;
        this.content = content;
        this.variables = new HashMap<String, Object>(variables);
        this.variables.put("content", content);
        this.variables.put("path", path);
        this.variables.put("name", Strings.substringBeforeLast(path.getFileName().toString(), "."));
    }

    public Path getPath() {
        return this.path;
    }

    public String getContent() {
        return this.content;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public static YamlFrontMatter parse(SourceFile sourceFile) {
        Matcher matcher = FRONT_MATTER.matcher(sourceFile.getSource());
        boolean matches = matcher.matches();
        String header = matches ? matcher.group(1) : null;
        String content = matches ? matcher.group(2) : sourceFile.getSource();
        return new YamlFrontMatter(sourceFile.getPath(), content, YamlFrontMatter.parseVariables(header));
    }

    private static Map<String, Object> parseVariables(String header) {
        if (header == null) {
            return Collections.emptyMap();
        }
        return YamlParser.INSTANCE.parseMap(header);
    }
}

