/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.logs;

import java.io.File;
import java.util.Collection;
import net.codestory.http.io.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Logs {
    private static final LogsImplementation LOG = Boolean.getBoolean("PROD_MODE") ? new Slf4jLogs() : new ConsoleLogs();

    private Logs() {
    }

    public static void unableToBindServer(Exception e) {
        LOG.error("Unable to bind server", e);
    }

    public static void mode(boolean production) {
        LOG.info(production ? "Production mode" : "Dev mode");
    }

    public static void started(int port) {
        LOG.info("Server started on port {}", port);
    }

    public static void compilerError(Exception e) {
        LOG.error(e.getMessage());
    }

    public static void unableToServerErrorPage(Exception e) {
        LOG.error("Unable to serve an error page", e);
    }

    public static void cachingOnDisk(File path) {
        LOG.info("Caching on disk @ {}", path.getAbsolutePath());
    }

    public static void uri(String uri) {
        LOG.info(uri);
    }

    public static void reloadingConfiguration() {
        LOG.info("Reloading configuration...");
    }

    public static void printKnownWebjars(Collection<String> uris, String extension) {
        LOG.error("Found these webjars files with extension: " + extension);
        for (String uri : uris) {
            LOG.error(" + " + Strings.substringAfter(uri, "META-INF/resources"));
        }
    }

    public static void printUnknownWebjar(String uri, String extension) {
        LOG.error("Unable to find this webjar file: " + uri);
        LOG.error("And no webjar file has extension [" + extension + "]");
    }

    public static void unableToConfigureRoutes(Throwable e) {
        LOG.error("Unable to configure routes properly", e);
    }

    private static class Slf4jLogs
    implements LogsImplementation {
        private static final Logger LOG = LoggerFactory.getLogger((String)"Fluent");

        private Slf4jLogs() {
        }

        @Override
        public void info(String message) {
            LOG.info(message);
        }

        @Override
        public void info(String message, Object argument) {
            LOG.info(message, argument);
        }

        @Override
        public void error(String message) {
            LOG.error(message);
        }

        @Override
        public void error(String message, Throwable e) {
            LOG.error(message, e);
        }
    }

    private static class ConsoleLogs
    implements LogsImplementation {
        private ConsoleLogs() {
        }

        @Override
        public void info(String message) {
            System.out.println(message);
        }

        @Override
        public void info(String message, Object argument) {
            System.out.println(message.replace("{}", argument.toString()));
        }

        @Override
        public void error(String message) {
            System.err.println(message);
        }

        @Override
        public void error(String message, Throwable e) {
            System.err.println(message);
            e.printStackTrace();
        }
    }

    private static interface LogsImplementation {
        public void info(String var1);

        public void info(String var1, Object var2);

        public void error(String var1);

        public void error(String var1, Throwable var2);
    }
}

