/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.twitter;

import java.net.URI;
import net.codestory.http.Context;
import net.codestory.http.NewCookie;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.filters.twitter.Authenticator;
import net.codestory.http.filters.twitter.TwitterAuthenticator;
import net.codestory.http.filters.twitter.User;
import net.codestory.http.payload.Payload;
import twitter4j.TwitterFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterAuthFilter
implements Filter {
    private final String siteUri;
    private final String uriPrefix;
    private final Authenticator twitterAuthenticator;

    public TwitterAuthFilter(String siteUri, String uriPrefix, String oAuthKey, String oAuthSecret) {
        this.siteUri = siteUri;
        this.uriPrefix = TwitterAuthFilter.validPrefix(uriPrefix);
        this.twitterAuthenticator = TwitterAuthFilter.createAuthenticator(oAuthKey, oAuthSecret);
    }

    @Override
    public boolean matches(String uri, Context context) {
        return uri.startsWith(this.uriPrefix);
    }

    private static String validPrefix(String prefix) {
        return prefix.endsWith("/") ? prefix : prefix + "/";
    }

    private static Authenticator createAuthenticator(String oAuthKey, String oAuthSecret) {
        Configuration config = new ConfigurationBuilder().setOAuthConsumerKey(oAuthKey).setOAuthConsumerSecret(oAuthSecret).build();
        TwitterFactory twitterFactory = new TwitterFactory(config);
        return new TwitterAuthenticator(twitterFactory);
    }

    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws Exception {
        if (uri.equals(this.uriPrefix + "authenticate")) {
            User user;
            try {
                String oauthToken = context.get("oauth_token");
                String oauthVerifier = context.get("oauth_verifier");
                user = this.twitterAuthenticator.authenticate(oauthToken, oauthVerifier);
            }
            catch (Exception e) {
                return Payload.forbidden();
            }
            return Payload.seeOther("/").withCookie(new NewCookie("userId", user.id.toString(), "/", true)).withCookie(new NewCookie("screenName", user.screenName, "/", true)).withCookie(new NewCookie("userPhoto", user.imageUrl, "/", true));
        }
        if (uri.equals(this.uriPrefix + "logout")) {
            return Payload.seeOther("/").withCookie(new NewCookie("userId", "", "/", false)).withCookie(new NewCookie("screenName", "", "/", false)).withCookie(new NewCookie("userPhoto", "", "/", false));
        }
        String userId = context.cookies().value("userId");
        if (userId != null && !userId.isEmpty()) {
            context.setCurrentUser(net.codestory.http.security.User.forLogin(userId));
            return nextFilter.get();
        }
        String host = context.get("Host");
        String callbackUri = (host == null ? this.siteUri : "http://" + host) + this.uriPrefix + "authenticate";
        URI authenticateURI = this.twitterAuthenticator.getAuthenticateURI(callbackUri);
        return Payload.seeOther(authenticateURI.toString());
    }
}

