/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

import java.nio.file.Path;
import java.nio.file.Paths;

public class Env {
    public static String DEFAULT_APP_FOLDER = "app";
    private final String appFolder;
    private final boolean prodMode;
    private final boolean disableClassPath;
    private final boolean disableFilesystem;
    private final boolean disableGzip;

    public Env() {
        this.appFolder = Env.getString("APP_FOLDER", DEFAULT_APP_FOLDER);
        this.prodMode = Env.getBoolean("PROD_MODE", false);
        this.disableClassPath = Env.getBoolean("http.disable.classpath", false);
        this.disableFilesystem = Env.getBoolean("http.disable.filesystem", false);
        this.disableGzip = Env.getBoolean("http.disable.gzip", false);
    }

    public Env(String appFolder, boolean prodMode, boolean disableClassPath, boolean disableFilesystem, boolean disableGzip) {
        this.appFolder = appFolder;
        this.prodMode = prodMode;
        this.disableClassPath = disableClassPath;
        this.disableFilesystem = disableFilesystem;
        this.disableGzip = disableGzip;
    }

    public static Env prod() {
        return new Env(DEFAULT_APP_FOLDER, true, false, false, false);
    }

    public static Env dev() {
        return new Env(DEFAULT_APP_FOLDER, false, false, false, true);
    }

    public Path appPath() {
        return Paths.get(this.appFolder(), new String[0]);
    }

    public String appFolder() {
        return this.appFolder;
    }

    public boolean prodMode() {
        return this.prodMode;
    }

    public int overriddenPort(int port) {
        return Env.getInt("PORT", port);
    }

    public boolean disableClassPath() {
        return this.disableClassPath;
    }

    public boolean disableFilesystem() {
        return this.disableFilesystem;
    }

    public boolean disableGzip() {
        return this.disableGzip;
    }

    private static String get(String propertyName) {
        String env = System.getenv(propertyName);
        return env != null ? env : System.getProperty(propertyName);
    }

    private static String getString(String propertyName, String defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : value;
    }

    private static boolean getBoolean(String propertyName, boolean defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private static int getInt(String propertyName, int defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Integer.parseInt(value);
    }
}

