/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializationUtils {
    public static <T extends Serializable> T clone(T object) {
        if (object == null) {
            return null;
        }
        try {
            return (T)((Serializable)SerializationUtils.deserialize(SerializationUtils.serialize(object)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to clone", e);
        }
    }

    private static byte[] serialize(Serializable obj) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(512);
        try (ObjectOutputStream out = new ObjectOutputStream(buffer);){
            out.writeObject(obj);
        }
        return buffer.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserialize(byte[] objectData) throws IOException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(objectData);
        try (ObjectInputStream in = new ObjectInputStream(buffer);){
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to deserialize", e);
        }
    }
}

