/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.convert;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.function.Function;

public class TypeConvert {
    private static ObjectMapper CURRENT_OBJECT_MAPPER = TypeConvert.createDefaultObjectMapper();

    private TypeConvert() {
    }

    private static ObjectMapper createDefaultObjectMapper() {
        return new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).registerModule((Module)new JSR310Module()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static void configureOrReplaceMapper(Function<ObjectMapper, ObjectMapper> configureOrReplace) {
        ObjectMapper replacementObjectMapper;
        ObjectMapper defaultObjectMapper = TypeConvert.createDefaultObjectMapper();
        CURRENT_OBJECT_MAPPER = replacementObjectMapper = configureOrReplace.apply(defaultObjectMapper);
    }

    public static <T> T fromJson(String json, Class<T> type) {
        try {
            return (T)CURRENT_OBJECT_MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse json", e);
        }
    }

    public static <T> T fromJson(String json, Type type) {
        try {
            return (T)CURRENT_OBJECT_MAPPER.readValue(json, TypeFactory.defaultInstance().constructType(type));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse json", e);
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        try {
            return (T)CURRENT_OBJECT_MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse json", e);
        }
    }

    public static <T> T convertValue(Object value, Class<T> type) {
        return (T)CURRENT_OBJECT_MAPPER.convertValue(value, type);
    }

    public static Object convertValue(Object value, Type type) {
        return CURRENT_OBJECT_MAPPER.convertValue(value, TypeFactory.defaultInstance().constructType(type));
    }

    public static <T> T convertValue(Object value, TypeReference<T> type) {
        return (T)CURRENT_OBJECT_MAPPER.convertValue(value, type);
    }

    public static byte[] toByteArray(Object value) {
        try {
            return CURRENT_OBJECT_MAPPER.writer().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize to json", e);
        }
    }

    public static String toJson(Object value) {
        try {
            return CURRENT_OBJECT_MAPPER.writer().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize to json", e);
        }
    }
}

