/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import net.codestory.http.Context;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Cache;
import net.codestory.http.routes.Route;

class StaticRoute
implements Route {
    private static final Path NOT_FOUND = Paths.get("", new String[0]);
    private final Resources resources;
    private final CompilerFacade compilers;
    private final Function<String, Object> findPath;

    StaticRoute(boolean cached, Resources resources, CompilerFacade compilers) {
        this.findPath = cached ? new Cache<String, Object>(this::findPath) : this::findPath;
        this.resources = resources;
        this.compilers = compilers;
    }

    @Override
    public boolean matchUri(String uri) {
        return this.findPath.apply(uri) != NOT_FOUND;
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Object body(Context context) {
        String uri = context.uri();
        return this.findPath.apply(uri);
    }

    private Object findPath(String uri) {
        try {
            Path path = this.resources.findExistingPath(uri);
            if (path != null && this.resources.isPublic(path)) {
                if (this.compilers.canCompile(Strings.extension(uri))) {
                    return this.resources.sourceFile(path);
                }
                return path;
            }
            Path sourcePath = this.compilers.findPublicSourceFor(uri);
            return sourcePath == null ? NOT_FOUND : this.resources.sourceFile(sourcePath);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read source file", e);
        }
    }
}

