/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.codestory.http.Cookies;
import net.codestory.http.Part;
import net.codestory.http.Query;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.security.User;
import net.codestory.http.templating.Site;

public class Context {
    private final Request request;
    private final Response response;
    private final IocAdapter iocAdapter;
    private final Site site;
    private User currentUser;

    public Context(Request request, Response response, IocAdapter iocAdapter, Site site) {
        this.request = request;
        this.response = response;
        this.iocAdapter = iocAdapter;
        this.site = site;
    }

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public Site site() {
        return this.site;
    }

    public String uri() {
        return this.request.uri();
    }

    public Cookies cookies() {
        return this.request.cookies();
    }

    public List<Part> parts() {
        return this.request.parts();
    }

    public Query query() {
        return this.request.query();
    }

    public String get(String key) {
        return this.request.query().get(key);
    }

    public String header(String name) {
        return this.request.header(name);
    }

    public List<String> headers(String name) {
        return this.request.headers(name);
    }

    public String method() {
        return this.request.method();
    }

    public <T> T getBean(Class<T> type) {
        return this.iocAdapter.get(type);
    }

    public void setCurrentUser(User user) {
        this.currentUser = user;
    }

    public User currentUser() {
        return this.currentUser;
    }

    public Object extract(Type type) throws IOException {
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isAssignableFrom(Context.class)) {
                return this;
            }
            if (clazz.isAssignableFrom(Request.class)) {
                return this.request;
            }
            if (clazz.isAssignableFrom(Response.class)) {
                return this.response;
            }
            if (clazz.isAssignableFrom(Cookies.class)) {
                return this.cookies();
            }
            if (clazz.isAssignableFrom(Query.class)) {
                return this.query();
            }
            if (clazz.isAssignableFrom(User.class)) {
                return this.currentUser;
            }
            if (clazz.isAssignableFrom(byte[].class)) {
                return this.request.contentAsBytes();
            }
            if (clazz.isAssignableFrom(String.class)) {
                return this.request.content();
            }
            if (clazz.isAssignableFrom(Site.class)) {
                return this.site;
            }
        }
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            if (List.class.isAssignableFrom((Class)rawType)) {
                Type argument;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length == 1 && (argument = actualTypeArguments[0]) instanceof Class && Part.class.isAssignableFrom((Class)argument)) {
                    return this.parts();
                }
            } else if (Map.class.isAssignableFrom((Class)rawType)) {
                return this.query().keyValues();
            }
        }
        return this.request().contentAs(type);
    }
}

