/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating.helpers;

import com.github.jknack.handlebars.Handlebars;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.codestory.http.compilers.CompilerFacade;

public class AssetsHelperSource {
    private final CompilerFacade compilers;
    private final Map<Path, String> sha1Cache = new ConcurrentHashMap<Path, String>();
    private final Function<Path, String> sha1Supplier;

    public AssetsHelperSource(boolean prodMode, CompilerFacade compilers) {
        this.compilers = compilers;
        this.sha1Supplier = prodMode ? path -> this.sha1Cache.computeIfAbsent((Path)path, p -> this.sha1((Path)p)) : path -> this.sha1((Path)path);
    }

    public CharSequence script(Object context) throws IOException {
        String uri = AssetsHelperSource.addExtensionIfMissing(context.toString(), ".js");
        return new Handlebars.SafeString((CharSequence)("<script src=\"" + this.uriWithSha1(uri) + "\"></script>"));
    }

    public CharSequence css(Object context) throws IOException {
        String uri = AssetsHelperSource.addExtensionIfMissing(context.toString(), ".css");
        return new Handlebars.SafeString((CharSequence)("<link rel=\"stylesheet\" href=\"" + this.uriWithSha1(uri) + "\">"));
    }

    private String uriWithSha1(String uri) throws IOException {
        Path path = this.compilers.findPublicSourceFor(uri);
        return path == null ? uri : uri + '?' + this.sha1Supplier.apply(path);
    }

    private static String addExtensionIfMissing(String uri, String extension) {
        return uri.endsWith(extension) ? uri : uri + extension;
    }

    private String sha1(Path path) {
        try {
            return this.compilers.compile(path).sha1();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to compute sha1 for: " + path);
        }
    }
}

