/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import net.codestory.http.Context;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.routes.Route;
import net.codestory.http.routes.UriParser;

class RouteWrapper
implements Route {
    private final String method;
    private final UriParser uriParser;
    private final AnyRoute route;

    RouteWrapper(String method, String uriPattern, AnyRoute route) {
        this.method = method;
        this.uriParser = new UriParser(uriPattern);
        this.route = route;
    }

    @Override
    public boolean matchUri(String uri) {
        return this.uriParser.matches(uri);
    }

    @Override
    public boolean matchMethod(String method) {
        return this.method.equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) && this.method.equalsIgnoreCase("GET");
    }

    @Override
    public Object body(Context context) throws Exception {
        String[] parameters = this.uriParser.params(context.uri(), context.request().query());
        return this.route.body(context, parameters);
    }
}

