/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import net.codestory.http.Configuration;
import net.codestory.http.reload.ParentLastClassLoader;
import net.codestory.http.routes.Routes;

public class ConfigurationReloadingProxy
implements Configuration {
    private final String fqcn;
    private final ClassLoader parent;

    public ConfigurationReloadingProxy(Class<? extends Configuration> configuration) {
        this.fqcn = configuration.getName();
        this.parent = this.getClass().getClassLoader();
    }

    @Override
    public void configure(Routes routes) {
        try {
            ParentLastClassLoader classLoader = new ParentLastClassLoader(this.parent);
            Class<?> type = classLoader.loadClass(this.fqcn);
            ((Configuration)type.newInstance()).configure(routes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to reload Configuration from classpath", e);
        }
    }
}

