/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.compilers.CompilersConfiguration;
import net.codestory.http.compilers.SourceFile;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.MemoizingSupplier;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.ViewCompiler;

public class CompilerFacade
implements CompilersConfiguration {
    protected final Resources resources;
    protected final Supplier<Compilers> compilers;
    protected final Supplier<HandlebarsCompiler> handlebars;
    protected final Supplier<ViewCompiler> viewCompiler;

    public CompilerFacade(Env env, Resources resources) {
        this.resources = resources;
        this.compilers = MemoizingSupplier.memoize(() -> new Compilers(env, resources));
        this.handlebars = MemoizingSupplier.memoize(() -> new HandlebarsCompiler(resources, this));
        this.viewCompiler = MemoizingSupplier.memoize(() -> new ViewCompiler(resources, this));
    }

    @Override
    public void registerCompiler(Supplier<Compiler> compilerFactory, String targetExtension, String firstExtension, String ... moreExtensions) {
        this.compilers.get().register(compilerFactory, targetExtension, firstExtension, moreExtensions);
    }

    @Override
    public void configureHandlebars(Consumer<Handlebars> action) {
        this.handlebars.get().configure(action);
    }

    @Override
    public void addHandlebarsResolver(ValueResolver resolver) {
        this.handlebars.get().addResolver(resolver);
    }

    public boolean canCompile(String extension) {
        return this.compilers.get().canCompile(extension);
    }

    public Set<String> extensionsThatCompileTo(String extension) {
        return this.compilers.get().extensionsThatCompileTo(extension);
    }

    public String compiledExtension(String extension) {
        return this.compilers.get().compiledExtension(extension);
    }

    public CacheEntry compile(Path path) throws IOException {
        return this.compilers.get().compile(this.resources.sourceFile(path));
    }

    public CacheEntry compile(SourceFile sourceFile) throws IOException {
        return this.compilers.get().compile(sourceFile);
    }

    public String handlebar(String template, Map<String, ?> variables) throws IOException {
        return this.handlebars.get().compile(template, variables);
    }

    public String renderView(String uri, Map<String, ?> variables) {
        return this.viewCompiler.get().render(uri, variables);
    }

    public Path findPublicSourceFor(String uri) {
        String extension = Strings.extension(uri);
        for (String sourceExtension : this.extensionsThatCompileTo(extension)) {
            Path sourcePath = Paths.get(Strings.replaceLast(uri, extension, sourceExtension), new String[0]);
            if (!this.resources.isPublic(sourcePath)) continue;
            return sourcePath;
        }
        return null;
    }
}

