/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.util.Collections;
import java.util.Map;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.NashornCompiler;
import net.codestory.http.compilers.SourceFile;
import net.codestory.http.io.Strings;

public class CoffeeSourceMapCompiler
implements Compiler {
    private final NashornCompiler nashornCompiler = NashornCompiler.get("META-INF/resources/webjars/coffee-script/1.8.0/coffee-script.min.js", "coffee-script/toSourceMap.js");

    @Override
    public String compile(SourceFile sourceFile) {
        Map<String, Object> options = Collections.singletonMap("__literate", sourceFile.hasExtension(".litcoffee"));
        String fileName = Strings.replaceLast(sourceFile.getFileName(), ".map", "");
        String sourceName = fileName + ".source";
        String source = sourceFile.getSource();
        return this.nashornCompiler.compile(fileName, sourceName, source, options);
    }
}

