/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating.helpers;

import com.github.jknack.handlebars.Handlebars;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Sha1;

public class AssetsHelperSource {
    private final Compilers compilers;

    public AssetsHelperSource(Compilers compilers) {
        this.compilers = compilers;
    }

    public CharSequence script(Object context) throws IOException {
        String uri = AssetsHelperSource.addExtensionIfMissing(context.toString(), ".js");
        return new Handlebars.SafeString((CharSequence)("<script src=\"" + this.uriWithSha1(uri) + "\"></script>"));
    }

    public CharSequence css(Object context) throws IOException {
        String uri = AssetsHelperSource.addExtensionIfMissing(context.toString(), ".css");
        return new Handlebars.SafeString((CharSequence)("<link rel=\"stylesheet\" href=\"" + this.uriWithSha1(uri) + "\">"));
    }

    private String uriWithSha1(String uri) throws IOException {
        Path path = this.findCompilableTo(uri);
        return path == null ? uri : uri + '?' + this.sha1(path);
    }

    private static String addExtensionIfMissing(String uri, String extension) {
        return uri.endsWith(extension) ? uri : uri + extension;
    }

    private String sha1(Path path) throws IOException {
        CacheEntry compile = this.compilers.compile(path, Resources.read(path, StandardCharsets.UTF_8));
        return Sha1.of(compile.toBytes());
    }

    private Path findCompilableTo(String uri) {
        String extension = Strings.extension(uri);
        for (String sourceExtension : this.compilers.extensionsThatCompileTo(extension)) {
            Path sourcePath = Paths.get(Strings.replaceLast(uri, extension, sourceExtension), new String[0]);
            if (!Resources.isPublic(sourcePath)) continue;
            return sourcePath;
        }
        return null;
    }
}

