/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.cache.ConcurrentMapTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.AbstractTemplateLoader;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.Site;
import net.codestory.http.templating.helpers.AssetsHelperSource;
import net.codestory.http.templating.helpers.EachReverseHelperSource;
import net.codestory.http.templating.helpers.EachValueHelperSource;
import net.codestory.http.templating.helpers.GoogleAnalyticsHelper;

public class HandlebarsCompiler {
    private final Handlebars handlebars;
    private final List<ValueResolver> resolvers;

    public HandlebarsCompiler(Compilers compilers) {
        this.handlebars = HandlebarsCompiler.handlebars(compilers);
        this.resolvers = new ArrayList<ValueResolver>(Arrays.asList(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE, MethodValueResolver.INSTANCE, Site.SiteValueResolver.INSTANCE}));
    }

    public String compile(String template, Map<String, ?> variables) throws IOException {
        return this.handlebars.compileInline(template).apply(this.context(variables));
    }

    private static Handlebars handlebars(final Compilers compilers) {
        return new Handlebars().startDelimiter("[[").endDelimiter("]]").registerHelpers((Object)new EachReverseHelperSource()).registerHelpers((Object)new EachValueHelperSource()).registerHelpers((Object)new GoogleAnalyticsHelper()).registerHelpers((Object)new AssetsHelperSource(compilers)).registerHelpers(StringHelpers.class).with((TemplateCache)new ConcurrentMapTemplateCache()).with(new TemplateLoader[]{new AbstractTemplateLoader(){

            public TemplateSource sourceAt(String location) throws IOException {
                Path include = Resources.findExistingPath("_includes", location);
                if (include == null) {
                    throw new IOException("Template not found " + location);
                }
                String template = Resources.read(include, StandardCharsets.UTF_8);
                CacheEntry compiled = compilers.compile(include, template);
                return new StringTemplateSource(location, compiled.content());
            }
        }});
    }

    private Context context(Map<String, ?> variables) {
        return Context.newBuilder(null).resolver((ValueResolver[])this.resolvers.stream().toArray(ValueResolver[]::new)).combine(variables).build();
    }

    public void configure(Consumer<Handlebars> action) {
        action.accept(this.handlebars);
    }

    public void addResolver(ValueResolver resolver) {
        this.resolvers.add(resolver);
    }
}

