/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.Context;
import net.codestory.http.compilers.CompiledPath;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.routes.Route;

class SourceMapRoute
implements Route {
    SourceMapRoute() {
    }

    @Override
    public boolean matchUri(String uri) {
        return uri.endsWith(".map") && Resources.isPublic(SourceMapRoute.pathSource(uri));
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public CompiledPath body(Context context) {
        String uri = context.uri();
        Path sourcePath = SourceMapRoute.pathSource(uri);
        Path mapPath = Paths.get(uri, new String[0]);
        return new CompiledPath(sourcePath, mapPath);
    }

    private static Path pathSource(String uri) {
        return Paths.get(Strings.substringBeforeLast(uri, ".map"), new String[0]);
    }
}

