/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.roles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.codestory.http.Context;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.payload.Payload;

public class RoleFilter
implements Filter {
    private final List<Permission> permissions = new ArrayList<Permission>();

    public RoleFilter(Map<String, String> rolesPerUriPrefix) {
        rolesPerUriPrefix.forEach((uriPrefix, role) -> this.permissions.add(new Permission((String)uriPrefix, (String)role)));
    }

    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws IOException {
        String role = this.findRole(uri);
        if (role != null && context.currentUser() != null && !context.currentUser().isInRole(role)) {
            return Payload.forbidden();
        }
        return nextFilter.get();
    }

    public String findRole(String uri) {
        for (Permission permission : this.permissions) {
            if (!uri.startsWith(permission.uriPrefix)) continue;
            return permission.role;
        }
        return null;
    }

    private static class Permission {
        final String uriPrefix;
        final String role;

        Permission(String uriPrefix, String role) {
            this.uriPrefix = uriPrefix;
            this.role = role;
        }
    }
}

