/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.io.InputStreams;

public final class NashornCompiler {
    private static final ConcurrentMap<String, NashornCompiler> CACHE_BY_SCRIPT = new ConcurrentHashMap<String, NashornCompiler>();
    private final CompiledScript compiledScript;
    private final Bindings bindings;

    private NashornCompiler(String script) {
        NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
        String engineVersion = factory.getEngineVersion();
        String cacheLocation = Paths.get(System.getProperty("user.home"), ".code-story", "nashorn_code_cache_" + engineVersion).toFile().getAbsolutePath();
        System.setProperty("nashorn.persistent.code.cache", cacheLocation);
        ScriptEngine nashorn = factory.getScriptEngine(new String[]{"--persistent-code-cache=true", "--lazy-compilation=false"});
        try {
            this.compiledScript = ((Compilable)((Object)nashorn)).compile(script);
            this.bindings = nashorn.getBindings(100);
        }
        catch (ScriptException e) {
            throw new IllegalStateException("Unable to compile javascript", e);
        }
    }

    public static NashornCompiler get(String ... scriptPaths) {
        String script = NashornCompiler.readScripts(scriptPaths);
        return CACHE_BY_SCRIPT.computeIfAbsent(script, NashornCompiler::new);
    }

    private static String readScripts(String ... scriptPaths) {
        StringBuilder concatenatedScript = new StringBuilder();
        for (String scriptPath : scriptPaths) {
            try (InputStream input = InputStreams.getResourceAsStream(scriptPath);){
                String content = InputStreams.readString(input, StandardCharsets.UTF_8);
                concatenatedScript.append(content).append("\n");
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read script " + scriptPath, e);
            }
        }
        return concatenatedScript.toString();
    }

    public synchronized String compile(Path path, String source, Map<String, Object> options) {
        this.bindings.put("__filename", (Object)this.getFileName(path));
        this.bindings.put("__source", (Object)source);
        options.forEach((name, value) -> this.bindings.put((String)name, value));
        try {
            return this.compiledScript.eval(this.bindings).toString();
        }
        catch (ScriptException e) {
            String message = NashornCompiler.cleanMessage(path, e.getCause().getMessage());
            throw new CompilerException(message);
        }
    }

    private String getFileName(Path path) {
        return path.getFileName().toString().replace(".map", ".source");
    }

    private static String cleanMessage(Path path, String message) {
        return message.replace("Unable to compile CoffeeScript [stdin]:", "Unable to compile " + path + ":");
    }
}

