/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.CoffeeCompiler;
import net.codestory.http.compilers.CoffeeSourceMapCompiler;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.DiskCache;
import net.codestory.http.compilers.LessCompiler;
import net.codestory.http.compilers.MarkdownCompiler;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.MemoizingSupplier;
import net.codestory.http.misc.Sha1;

public class Compilers {
    private final Map<String, Supplier<Compiler>> compilerByExtension = new HashMap<String, Supplier<Compiler>>();
    private final Map<String, Set<String>> extensionsThatCompileTo = new HashMap<String, Set<String>>();
    private final Map<String, String> compiledExtension = new HashMap<String, String>();
    private final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private final DiskCache diskCache;

    public Compilers(Env env) {
        boolean prodMode = env.prodMode();
        this.diskCache = new DiskCache("V5", prodMode);
        this.register(() -> new CoffeeCompiler(prodMode), ".js", ".coffee", ".litcoffee");
        this.register(() -> new CoffeeSourceMapCompiler(), ".map", ".coffee.map", ".litcoffee.map");
        this.register(() -> new MarkdownCompiler(), ".html", ".md", ".markdown");
        this.register(() -> new LessCompiler(prodMode), ".css", ".less", new String[0]);
    }

    public void register(Supplier<Compiler> compilerFactory, String targetExtension, String firstExtension, String ... moreExtensions) {
        Supplier<Compiler> compilerLazyFactory = MemoizingSupplier.memoize(compilerFactory);
        Set uncompiledExtensions = this.extensionsThatCompileTo.computeIfAbsent(targetExtension, k -> new HashSet());
        this.compilerByExtension.put(firstExtension, compilerLazyFactory);
        this.compiledExtension.put(firstExtension, targetExtension);
        uncompiledExtensions.add(firstExtension);
        for (String extension : moreExtensions) {
            this.compilerByExtension.put(extension, compilerLazyFactory);
            this.compiledExtension.put(extension, targetExtension);
            uncompiledExtensions.add(extension);
        }
    }

    public boolean canCompile(String extension) {
        return this.compilerByExtension.containsKey(extension);
    }

    public Set<String> extensionsThatCompileTo(String extension) {
        return this.extensionsThatCompileTo.getOrDefault(extension, Collections.emptySet());
    }

    public String compiledExtension(String extension) {
        return this.compiledExtension.get(extension);
    }

    public CacheEntry compile(Path path, String content) {
        return this.cache.computeIfAbsent(path.toString() + ";" + content, ignore -> this.doCompile(path, content));
    }

    private CacheEntry doCompile(Path path, String content) {
        for (Map.Entry<String, Supplier<Compiler>> entry : this.compilerByExtension.entrySet()) {
            String extension = entry.getKey();
            if (!path.toString().endsWith(extension)) continue;
            if (extension.equals(".less") && content.contains("@import")) {
                return CacheEntry.noCache(this.doCompile(path, content, entry.getValue()));
            }
            String sha1 = Sha1.of(content);
            return this.diskCache.computeIfAbsent(sha1, extension, () -> this.doCompile(path, content, (Supplier)entry.getValue()));
        }
        return CacheEntry.fromString(content);
    }

    private String doCompile(Path path, String content, Supplier<Compiler> compilerSupplier) {
        Compiler compiler = compilerSupplier.get();
        return compiler.compile(path, content);
    }
}

