/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import net.codestory.http.internal.Unwrappable;

public interface Query
extends Unwrappable {
    public Collection<String> keys();

    public Iterable<String> all(String var1);

    default public String get(String name) {
        Iterator<String> values = this.all(name).iterator();
        return values.hasNext() ? values.next() : null;
    }

    default public Map<String, String> keyValues() {
        return this.keys().stream().collect(Collectors.toMap(key -> key, key -> this.get((String)key)));
    }

    default public int getInteger(String name) {
        String value = this.get(name);
        return value != null ? Integer.parseInt(value) : 0;
    }

    default public long getLong(String name) {
        String value = this.get(name);
        return value != null ? Long.parseLong(value) : 0L;
    }

    default public float getFloat(String name) {
        String value = this.get(name);
        return value != null ? Float.parseFloat(value) : 0.0f;
    }

    default public double getDouble(String name) {
        String value = this.get(name);
        return value != null ? Double.parseDouble(value) : 0.0;
    }

    default public boolean getBoolean(String name) {
        String value = this.get(name);
        return value != null ? Boolean.valueOf(value) : false;
    }
}

