/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.security;

import java.io.Serializable;
import java.util.stream.Stream;

public interface User
extends Serializable {
    public String name();

    public String login();

    public String[] roles();

    default public boolean isInRole(String expectedRole) {
        return Stream.of(this.roles()).anyMatch(expectedRole::equals);
    }

    public static User forLogin(final String login) {
        return new User(){

            @Override
            public String name() {
                return login;
            }

            @Override
            public String login() {
                return login;
            }

            @Override
            public String[] roles() {
                return new String[0];
            }
        };
    }
}

