/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import net.codestory.http.Context;
import net.codestory.http.compilers.CompiledPath;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Cache;
import net.codestory.http.routes.Route;

class StaticRoute
implements Route {
    private static final Path NOT_FOUND = Paths.get("", new String[0]);
    private final CompilerFacade compilers;
    private final Function<String, Object> findPath;

    StaticRoute(boolean cached, CompilerFacade compilers) {
        this.compilers = compilers;
        this.findPath = cached ? new Cache<String, Object>(this::findPath) : this::findPath;
    }

    @Override
    public boolean matchUri(String uri) {
        return this.findPath.apply(uri) != NOT_FOUND;
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Object body(Context context) {
        String uri = context.uri();
        return this.findPath.apply(uri);
    }

    private Object findPath(String uri) {
        Path path = Resources.findExistingPath(uri);
        if (path != null && Resources.isPublic(path)) {
            if (this.compilers.canCompile(Strings.extension(uri))) {
                return new CompiledPath(path, path);
            }
            return path;
        }
        return this.findUriCompilableTo(uri);
    }

    private Object findUriCompilableTo(String uri) {
        String extension = Strings.extension(uri);
        for (String sourceExtension : this.compilers.extensionsThatCompileTo(extension)) {
            Path sourcePath = Paths.get(Strings.replaceLast(uri, extension, sourceExtension), new String[0]);
            if (!Resources.isPublic(sourcePath)) continue;
            return new CompiledPath(sourcePath, sourcePath);
        }
        return NOT_FOUND;
    }
}

