/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.NashornCompiler;

public class CoffeeCompiler
implements Compiler {
    private final NashornCompiler nashornCompiler = NashornCompiler.get("META-INF/resources/webjars/coffee-script/1.8.0/coffee-script.min.js", "coffee-script/toJs.js");
    private final boolean sourceMaps;

    public CoffeeCompiler(boolean prodMode) {
        this.sourceMaps = !prodMode;
    }

    @Override
    public String compile(Path path, String source) {
        Map<String, Object> options = Collections.singletonMap("__literate", path.toString().endsWith(".litcoffee"));
        String javascript = this.nashornCompiler.compile(path, source, options);
        if (this.sourceMaps) {
            return CoffeeCompiler.addSourceMapping(javascript, path);
        }
        return javascript;
    }

    private static String addSourceMapping(String javascript, Path path) {
        return javascript + "\n//# sourceMappingURL=" + path.getFileName() + ".map";
    }
}

