/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.codestory.http.Configuration;
import net.codestory.http.io.ClassPaths;
import net.codestory.http.logs.Logs;
import net.codestory.http.misc.Env;
import net.codestory.http.reload.FolderWatcher;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;

class ReloadingRoutesProvider
implements RoutesProvider {
    private final Env env;
    private final Configuration configuration;
    private final AtomicBoolean dirty;
    private List<FolderWatcher> classesWatchers;
    private FolderWatcher appWatcher;
    private RouteCollection routes;

    ReloadingRoutesProvider(Env env, Configuration configuration) {
        this.env = env;
        this.configuration = configuration;
        this.dirty = new AtomicBoolean(true);
    }

    protected Stream<Path> classpathFolders() {
        URL[] urls = ClassPaths.getUrls(Thread.currentThread().getContextClassLoader());
        return Stream.of(urls).map(url -> Paths.get(ReloadingRoutesProvider.toUri(url)));
    }

    private static URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to convert URL to URI: " + url, e);
        }
    }

    @Override
    public synchronized RouteCollection get() {
        if (this.dirty.get()) {
            Logs.reloadingConfiguration();
            this.routes = new RouteCollection(this.env);
            try {
                this.routes.configure(this.configuration);
                if (this.classesWatchers == null) {
                    this.classesWatchers = this.classpathFolders().map(path -> new FolderWatcher((Path)path, ev -> this.dirty.set(true))).collect(Collectors.toList());
                }
                this.classesWatchers.forEach(FolderWatcher::ensureStarted);
                if (this.appWatcher == null) {
                    this.appWatcher = new FolderWatcher(this.env.appPath(), ev -> this.dirty.set(true));
                }
                this.appWatcher.ensureStarted();
            }
            catch (Throwable e) {
                Logs.unableToConfigureRoutes(e);
            }
            this.dirty.set(false);
        }
        return this.routes;
    }
}

