/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import net.codestory.http.internal.Handler;
import net.codestory.http.internal.HttpServerWrapper;
import net.codestory.http.internal.SimpleRequest;
import net.codestory.http.internal.SimpleResponse;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerSocketProcessor;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.connect.SocketConnection;

public class SimpleServerWrapper
implements HttpServerWrapper,
Container {
    private final Handler handler;
    private final int count;
    private final int select;
    private SocketConnection socketConnection;

    public SimpleServerWrapper(Handler handler) {
        this(handler, 8, 1);
    }

    public SimpleServerWrapper(Handler handler, int count, int select) {
        this.handler = handler;
        this.count = count;
        this.select = select;
    }

    @Override
    public void start(int port, SSLContext context, boolean authReq) throws IOException {
        ContainerSocketProcessor server = new ContainerSocketProcessor((Container)this, this.count, this.select);
        this.socketConnection = new SocketConnection((SocketProcessor)(authReq ? new AuthRequiredServer((SocketProcessor)server) : server));
        this.socketConnection.connect((SocketAddress)new InetSocketAddress(port), context);
    }

    public void handle(Request request, Response response) {
        this.handler.handle(new SimpleRequest(request), new SimpleResponse(response));
    }

    @Override
    public void stop() throws IOException {
        this.socketConnection.close();
    }

    private static class AuthRequiredServer
    implements SocketProcessor {
        private final SocketProcessor delegate;

        AuthRequiredServer(SocketProcessor delegate) {
            this.delegate = delegate;
        }

        public void process(Socket socket) throws IOException {
            socket.getEngine().setNeedClientAuth(true);
            this.delegate.process(socket);
        }

        public void stop() throws IOException {
            this.delegate.stop();
        }
    }
}

