/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.logs;

import java.io.File;
import java.util.Collection;
import net.codestory.http.io.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Logs {
    private static final LogsImplementation logs = Boolean.getBoolean("PROD_MODE") ? new Slf4jLogs() : new ConsoleLogs();

    private Logs() {
    }

    public static void unableToBindServer(Exception e) {
        logs.error("Unable to bind server", e);
    }

    public static void mode(boolean production) {
        logs.info(production ? "Production mode" : "Dev mode");
    }

    public static void started(int port) {
        logs.info("Server started on port {}", port);
    }

    public static void compilerError(Exception e) {
        logs.error(e.getMessage());
    }

    public static void unableToServerErrorPage(Exception e) {
        logs.error("Unable to serve an error page", e);
    }

    public static void cachingOnDisk(File path) {
        logs.info("Caching on disk @ {}", path.getAbsolutePath());
    }

    public static void uri(String uri) {
        logs.info(uri);
    }

    public static void reloadingConfiguration() {
        logs.info("Reloading configuration...");
    }

    public static void printKnownWebjars(Collection<String> uris) {
        logs.info("Found these webjars files:");
        for (String uri : uris) {
            logs.info(" + " + Strings.substringAfter(uri, "META-INF/resources"));
        }
    }

    private static class Slf4jLogs
    implements LogsImplementation {
        private static final Logger LOG = LoggerFactory.getLogger((String)"Fluent");

        private Slf4jLogs() {
        }

        @Override
        public void info(String message) {
            LOG.info(message);
        }

        @Override
        public void info(String message, Object argument) {
            LOG.info(message, argument);
        }

        @Override
        public void error(String message) {
            LOG.error(message);
        }

        @Override
        public void error(String message, Throwable e) {
            LOG.error(message, e);
        }
    }

    private static class ConsoleLogs
    implements LogsImplementation {
        private ConsoleLogs() {
        }

        @Override
        public void info(String message) {
            System.out.println(message);
        }

        @Override
        public void info(String message, Object argument) {
            System.out.println(message.replace("{}", argument.toString()));
        }

        @Override
        public void error(String message) {
            System.err.println(message);
        }

        @Override
        public void error(String message, Throwable e) {
            System.err.println(message);
            e.printStackTrace();
        }
    }

    private static interface LogsImplementation {
        public void info(String var1);

        public void info(String var1, Object var2);

        public void error(String var1);

        public void error(String var1, Throwable var2);
    }
}

