/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.stream.Collectors;
import net.codestory.http.Cookies;
import net.codestory.http.Part;
import net.codestory.http.Query;
import net.codestory.http.Request;
import net.codestory.http.internal.SimpleCookies;
import net.codestory.http.internal.SimplePart;
import net.codestory.http.internal.SimpleQuery;

class SimpleRequest
implements Request {
    private final org.simpleframework.http.Request request;

    SimpleRequest(org.simpleframework.http.Request request) {
        this.request = request;
    }

    @Override
    public String uri() {
        return this.request.getPath().getPath();
    }

    @Override
    public String method() {
        return this.request.getMethod();
    }

    @Override
    public String header(String name) {
        return this.request.getValue(name);
    }

    @Override
    public String content() throws IOException {
        return this.request.getContent();
    }

    @Override
    public String contentType() {
        return this.request.getContentType().getType();
    }

    @Override
    public InputStream inputStream() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    public List<String> headerNames() {
        return this.request.getNames();
    }

    @Override
    public List<String> headers(String name) {
        return this.request.getValues(name);
    }

    @Override
    public InetSocketAddress clientAddress() {
        return this.request.getClientAddress();
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure();
    }

    @Override
    public Cookies cookies() {
        return new SimpleCookies(this.request);
    }

    @Override
    public Query query() {
        return new SimpleQuery(this.request.getQuery());
    }

    @Override
    public List<Part> parts() {
        return this.request.getParts().stream().map(part -> new SimplePart((org.simpleframework.http.Part)part)).collect(Collectors.toList());
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return (T)(type.isInstance(this.request) ? this.request : null);
    }
}

