/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.NashornCompiler;

public class CoffeeCompiler
implements Compiler {
    private final NashornCompiler nashornCompiler = new NashornCompiler("META-INF/resources/webjars/coffee-script/1.8.0/coffee-script.min.js", "coffee-script/toJs.js");
    private final boolean sourceMaps;

    public CoffeeCompiler(boolean prodMode) {
        this.sourceMaps = !prodMode;
    }

    @Override
    public String compile(final Path path, String source) {
        String javascript = this.nashornCompiler.compile(path, source, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("__literate", path.toString().endsWith(".litcoffee"));
            }
        });
        if (this.sourceMaps) {
            return CoffeeCompiler.addSourceMapping(javascript, path);
        }
        return javascript;
    }

    private static String addSourceMapping(String javascript, Path path) {
        return javascript + "\n//# sourceMappingURL=" + path.getFileName() + ".map";
    }
}

