/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.util.HashMap;
import java.util.Map;
import net.codestory.http.Cookie;
import net.codestory.http.convert.TypeConvert;

public interface Cookies
extends Iterable<Cookie> {
    public Cookie get(String var1);

    default public Map<String, String> keyValues() {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        this.forEach(cookie -> keyValues.put(cookie.name(), cookie.value()));
        return keyValues;
    }

    default public String value(String name) {
        Cookie cookie = this.get(name);
        return cookie == null ? null : cookie.value();
    }

    default public String value(String name, String defaultValue) {
        String value = this.value(name);
        return value == null ? defaultValue : value;
    }

    default public int value(String name, int defaultValue) {
        String value = this.value(name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    default public long value(String name, long defaultValue) {
        String value = this.value(name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    default public boolean value(String name, boolean defaultValue) {
        String value = this.value(name);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    default public <T> T value(String name, T defaultValue) {
        Object value = this.value(name, defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    default public <T> T value(String name, Class<T> type) {
        String value = this.value(name);
        if (value == null) {
            return null;
        }
        if (value.indexOf(92) != -1) {
            value = value.replace("\\", "");
        }
        return TypeConvert.fromJson(value, type);
    }
}

