/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.Context;
import net.codestory.http.compilers.CompiledPath;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;

class SourceMapRoute
implements Route {
    private final CompilerFacade compilers;

    SourceMapRoute(CompilerFacade compilers) {
        this.compilers = compilers;
    }

    @Override
    public boolean matchUri(String uri) {
        return uri.endsWith(".map") && Resources.isPublic(SourceMapRoute.pathSource(uri));
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Payload body(Context context) throws IOException {
        String uri = context.uri();
        Path sourcePath = SourceMapRoute.pathSource(uri);
        Path mapPath = Paths.get(uri, new String[0]);
        return new Payload(new CompiledPath(sourcePath, mapPath));
    }

    private static Path pathSource(String uri) {
        return Paths.get(Strings.substringBeforeLast(uri, ".map"), new String[0]);
    }
}

