/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.net.BindException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import net.codestory.http.Configuration;
import net.codestory.http.Context;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.errors.ErrorPage;
import net.codestory.http.errors.HttpException;
import net.codestory.http.internal.Handler;
import net.codestory.http.internal.HttpServerWrapper;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.NamedDaemonThreadFactory;
import net.codestory.http.payload.Payload;
import net.codestory.http.payload.PayloadWriter;
import net.codestory.http.reload.ConfigurationReloadingProxy;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;
import net.codestory.http.ssl.SSLContextFactory;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.Site;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebServer<T extends AbstractWebServer<T>> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractWebServer.class);
    protected final Env env = this.createEnv();
    protected final CompilerFacade compilers = this.createCompilerFacade();
    protected final ExecutorService executorService = this.createExecutorService();
    protected HttpServerWrapper server;
    protected RoutesProvider routesProvider;
    protected int port;

    protected AbstractWebServer() {
    }

    protected abstract HttpServerWrapper createHttpServer(Handler var1) throws Exception;

    public T configure(Configuration configuration) {
        this.routesProvider = this.env.prodMode() ? RoutesProvider.fixed(this.env, this.compilers, configuration) : RoutesProvider.reloading(this.env, this.compilers, configuration);
        return (T)this;
    }

    public T configure(Class<? extends Configuration> configuration) {
        return this.configure(new ConfigurationReloadingProxy(configuration));
    }

    public T startOnRandomPort() {
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            try {
                int port = 8183 + random.nextInt(10000);
                return this.start(port);
            }
            catch (Exception e) {
                LOG.error("Unable to bind server", (Throwable)e);
                continue;
            }
        }
        throw new IllegalStateException("Unable to start server");
    }

    public T start() {
        return this.start(8080);
    }

    public T start(int port) {
        return this.startWithContext(port, null, false);
    }

    public T startSSL(int port, Path pathCertificate, Path pathPrivateKey) {
        return this.startSSL(port, Arrays.asList(pathCertificate), pathPrivateKey, null);
    }

    public T startSSL(int port, List<Path> pathChain, Path pathPrivateKey) {
        return this.startSSL(port, pathChain, pathPrivateKey, null);
    }

    public T startSSL(int port, List<Path> pathChain, Path pathPrivateKey, List<Path> pathTrustAnchors) {
        SSLContext context;
        try {
            context = new SSLContextFactory().create(pathChain, pathPrivateKey, pathTrustAnchors);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read certificate or key", e);
        }
        boolean authReq = pathTrustAnchors != null;
        return this.startWithContext(port, context, authReq);
    }

    protected T startWithContext(int port, SSLContext context, boolean authReq) {
        try {
            this.server = this.createHttpServer(this::handle);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create http server", e);
        }
        if (this.routesProvider == null) {
            this.configure(Configuration.NO_ROUTE);
        }
        this.port = this.env.overriddenPort(port);
        try {
            LOG.info(this.env.prodMode() ? "Production mode" : "Dev mode");
            this.server.start(this.port, context, authReq);
            LOG.info("Server started on port {}", (Object)this.port);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (BindException e) {
            throw new IllegalStateException("Port already in use " + this.port);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to bind the web server on port " + this.port, e);
        }
        return (T)this;
    }

    public int port() {
        return this.port;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to stop the web server", e);
        }
    }

    protected void handle(Request request, Response response) {
        try {
            RouteCollection routes = this.routesProvider.get();
            Context context = routes.createContext(request, response);
            Payload payload = routes.apply(context);
            if (payload.isError()) {
                payload = this.errorPage(payload);
            }
            PayloadWriter payloadWriter = routes.createPayloadWriter(request, response, this.executorService);
            payloadWriter.writeAndClose(payload);
        }
        catch (Exception e) {
            PayloadWriter payloadWriter = new PayloadWriter(request, response, this.env, new Site(this.env), this.compilers, this.executorService);
            this.handleServerError(payloadWriter, e);
        }
    }

    protected void handleServerError(PayloadWriter payloadWriter, Exception e) {
        try {
            if (e instanceof CompilerException) {
                LOG.error(e.getMessage());
            } else if (!(e instanceof HttpException) && !(e instanceof NoSuchElementException)) {
                e.printStackTrace();
            }
            Payload errorPage = this.errorPage(e).withHeader("reason", e.getMessage());
            payloadWriter.writeAndClose(errorPage);
        }
        catch (IOException error) {
            LOG.warn("Unable to serve an error page", (Throwable)error);
        }
    }

    protected Payload errorPage(Payload payload) {
        return this.errorPage(payload, null);
    }

    protected Payload errorPage(Exception e) {
        int code = 500;
        if (e instanceof HttpException) {
            code = ((HttpException)e).code();
        } else if (e instanceof NoSuchElementException) {
            code = 404;
        }
        return this.errorPage(new Payload(code), e);
    }

    protected Payload errorPage(Payload payload, Exception e) {
        Exception shownError = this.env.prodMode() ? null : e;
        return new ErrorPage(payload, shownError).payload();
    }

    protected Env createEnv() {
        return new Env();
    }

    protected CompilerFacade createCompilerFacade() {
        Compilers compilers = new Compilers(this.env);
        HandlebarsCompiler handlebar = new HandlebarsCompiler(compilers);
        return new CompilerFacade(compilers, handlebar);
    }

    protected ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool(new NamedDaemonThreadFactory());
    }
}

