/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.codestory.http.Configuration;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.ClassPaths;
import net.codestory.http.misc.Env;
import net.codestory.http.reload.FolderWatcher;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReloadingRoutesProvider
implements RoutesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadingRoutesProvider.class);
    private final Env env;
    private final CompilerFacade compiler;
    private final Configuration configuration;
    private final AtomicBoolean dirty;
    private final List<FolderWatcher> classesWatchers;
    private final FolderWatcher appWatcher;
    private RouteCollection routes;

    ReloadingRoutesProvider(Env env, CompilerFacade compiler, Configuration configuration) {
        this.env = env;
        this.compiler = compiler;
        this.configuration = configuration;
        this.dirty = new AtomicBoolean(true);
        this.classesWatchers = this.classpathFolders().stream().map(path -> new FolderWatcher((Path)path, ev -> this.dirty.set(true))).collect(Collectors.toList());
        this.appWatcher = new FolderWatcher(env.appPath(), ev -> this.dirty.set(true));
    }

    protected List<Path> classpathFolders() {
        URL[] urls = ClassPaths.getUrls(Thread.currentThread().getContextClassLoader());
        return Stream.of(urls).map(url -> Paths.get(ReloadingRoutesProvider.toUri(url))).collect(Collectors.toList());
    }

    private static URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to convert URL to URI: " + url, e);
        }
    }

    @Override
    public synchronized RouteCollection get() {
        if (this.dirty.get()) {
            LOG.info("Reloading configuration...");
            this.classesWatchers.forEach(FolderWatcher::ensureStarted);
            this.appWatcher.ensureStarted();
            this.routes = new RouteCollection(this.env, this.compiler);
            this.configuration.configure(this.routes);
            this.routes.installExtensions();
            this.routes.addStaticRoutes(false);
            this.dirty.set(false);
        }
        return this.routes;
    }
}

