/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.util.List;
import java.util.Map;
import org.markdown4j.Plugin;

class TablePlugin
extends Plugin {
    public TablePlugin() {
        super("table");
    }

    public void emit(StringBuilder result, List<String> lines, Map<String, String> parameters) {
        String id = parameters.get("id");
        if (id == null) {
            result.append("<table>\n");
        } else {
            result.append(String.format("<table id=\"%s\">\n", id));
        }
        boolean header = true;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            result.append("<tr>");
            for (String value : line.split("[|]")) {
                result.append(header ? "<th>" : "<td>");
                result.append(value);
                result.append(header ? "</th>" : "</td>");
            }
            header = false;
            result.append("</tr>\n");
        }
        result.append("</table>\n");
    }
}

