/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.payload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.CompiledPath;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Dates;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.Md5;
import net.codestory.http.payload.DataSupplier;
import net.codestory.http.payload.Payload;
import net.codestory.http.templating.Model;
import net.codestory.http.templating.ModelAndView;
import net.codestory.http.templating.Site;
import net.codestory.http.templating.Template;
import net.codestory.http.types.ContentTypes;

public class PayloadWriter {
    private final Env env;
    private final Site site;
    private final Request request;
    private final Response response;

    public PayloadWriter(Env env, Site site, Request request, Response response) {
        this.request = request;
        this.response = response;
        this.env = env;
        this.site = site;
    }

    public void writeAndClose(Payload payload) throws IOException {
        try {
            this.write(payload);
        }
        finally {
            if (!this.isStream(payload)) {
                this.close();
            }
        }
    }

    protected void close() {
        try {
            this.response.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void write(Payload payload) throws IOException {
        payload.headers().forEach(this.response::setValue);
        payload.cookies().forEach(this.response::setCookie);
        long lastModified = this.getLastModified(payload);
        if (lastModified >= 0L) {
            String previousLastModified = Strings.stripQuotes(this.request.header("If-Modified-Since"));
            if (previousLastModified != null && lastModified < Dates.parse_rfc_1123(previousLastModified)) {
                this.response.setStatus(304);
                return;
            }
            this.response.setValue("Last-Modified", Dates.to_rfc_1123(lastModified));
        }
        int code = payload.code();
        Object content = payload.rawContent();
        if (content == null) {
            this.response.setStatus(code);
            this.response.setContentLength(0L);
            return;
        }
        String uri = this.request.uri();
        String type = this.getContentType(payload, uri);
        this.response.setValue("Content-Type", type);
        this.response.setStatus(code);
        if ("HEAD".equals(this.request.method()) || code == 204 || code == 304 || code >= 100 && code < 200) {
            return;
        }
        if (this.isStream(payload)) {
            this.streamPayload(payload);
        } else {
            String previousEtag;
            DataSupplier lazyData = DataSupplier.cache(() -> this.getData(payload, uri));
            String etag = payload.headers().get("ETag");
            if (etag == null) {
                etag = this.etag(lazyData.get());
            }
            if (etag.equals(previousEtag = Strings.stripQuotes(this.request.header("If-None-Match")))) {
                this.response.setStatus(304);
                return;
            }
            this.response.setValue("ETag", etag);
            byte[] data = lazyData.get();
            this.write(data);
        }
    }

    protected void streamPayload(Payload payload) throws IOException {
        this.response.setValue("Cache-Control", "no-cache");
        this.response.setValue("Connection", "keep-alive");
        PrintStream printStream = this.response.printStream();
        Stream stream = (Stream)payload.rawContent();
        new Thread(() -> {
            stream.forEach(item -> printStream.append("id: ").append(Long.toString(System.currentTimeMillis())).append("\n").append("data: ").append(TypeConvert.toJson(item)).append("\n\n").flush());
            this.close();
        }).start();
    }

    protected void write(byte[] data) throws IOException {
        block4: {
            try {
                if (this.shouldGzip()) {
                    this.response.setValue("Content-Encoding", "gzip");
                    GZIPOutputStream gzip = new GZIPOutputStream(this.response.outputStream());
                    gzip.write(data);
                    gzip.finish();
                } else {
                    this.response.setContentLength(data.length);
                    this.response.outputStream().write(data);
                }
            }
            catch (IOException e) {
                if (this.shouldIgnoreError(e)) break block4;
                throw e;
            }
        }
    }

    protected boolean shouldGzip() {
        String acceptEncoding = this.request.header("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip") && this.env.prodMode() && !this.env.disableGzip();
    }

    protected boolean shouldIgnoreError(IOException e) {
        String message;
        Throwable cause = e.getCause();
        return cause != null && (message = cause.getMessage()) != null && (message.contains("Connection reset by peer") || message.contains("Broken pipe"));
    }

    protected String etag(byte[] data) {
        return Md5.of(data);
    }

    protected boolean isStream(Payload payload) {
        Object content = payload.rawContent();
        return content instanceof Stream;
    }

    protected String getContentType(Payload payload, String uri) {
        String contentType = payload.rawContentType();
        if (contentType != null) {
            return contentType;
        }
        Object content = payload.rawContent();
        if (content instanceof File) {
            File file = (File)content;
            return ContentTypes.get(file.toPath());
        }
        if (content instanceof Path) {
            Path path = (Path)content;
            return ContentTypes.get(path);
        }
        if (content instanceof CompiledPath) {
            CompiledPath compiledPath = (CompiledPath)content;
            return ContentTypes.get(compiledPath.getPath());
        }
        if (content instanceof byte[]) {
            return "application/octet-stream";
        }
        if (content instanceof String) {
            return "text/html;charset=UTF-8";
        }
        if (content instanceof CacheEntry) {
            return "text/html;charset=UTF-8";
        }
        if (content instanceof InputStream) {
            return "application/octet-stream";
        }
        if (content instanceof Stream) {
            return "text/event-stream";
        }
        if (content instanceof ModelAndView) {
            Path path = Resources.findExistingPath(((ModelAndView)content).view());
            Objects.requireNonNull(path, "View not found for " + uri);
            return ContentTypes.get(path);
        }
        if (content instanceof Model) {
            Path path = Resources.findExistingPath(uri);
            Objects.requireNonNull(path, "View not found for " + uri);
            return ContentTypes.get(path);
        }
        return "application/json;charset=UTF-8";
    }

    protected byte[] getData(Payload payload, String uri) throws IOException {
        Object content = payload.rawContent();
        if (content == null) {
            return null;
        }
        if (content instanceof File) {
            return this.forPath(((File)content).toPath());
        }
        if (content instanceof Path) {
            return this.forPath((Path)content);
        }
        if (content instanceof CompiledPath) {
            return this.forCompiledPath((CompiledPath)content);
        }
        if (content instanceof byte[]) {
            return (byte[])content;
        }
        if (content instanceof String) {
            return this.forString((String)content);
        }
        if (content instanceof CacheEntry) {
            return ((CacheEntry)content).toBytes();
        }
        if (content instanceof InputStream) {
            return this.forInputStream((InputStream)content);
        }
        if (content instanceof ModelAndView) {
            return this.forModelAndView((ModelAndView)content);
        }
        if (content instanceof Model) {
            return this.forModelAndView(ModelAndView.of(uri, (Model)content));
        }
        return TypeConvert.toByteArray(content);
    }

    protected long getLastModified(Payload payload) throws IOException {
        Object content = payload.rawContent();
        if (content instanceof File) {
            return ((File)content).lastModified();
        }
        if (content instanceof Path) {
            return ((Path)content).toFile().lastModified();
        }
        if (content instanceof CompiledPath) {
            return ((CompiledPath)content).compile().lastModified();
        }
        if (content instanceof CacheEntry) {
            return ((CacheEntry)content).lastModified();
        }
        return -1L;
    }

    protected byte[] forString(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    protected byte[] forInputStream(InputStream stream) throws IOException {
        return InputStreams.readBytes(stream);
    }

    protected byte[] forModelAndView(ModelAndView modelAndView) {
        String view = modelAndView.view();
        HashMap<String, Object> keyValues = new HashMap<String, Object>();
        keyValues.putAll(modelAndView.model().keyValues());
        keyValues.put("cookies", this.request.cookies().keyValues());
        keyValues.put("site", this.site);
        CacheEntry html = new Template(view).render(keyValues);
        return html.toBytes();
    }

    protected byte[] forPath(Path path) throws IOException {
        if (ContentTypes.support_templating(path)) {
            return this.forTemplatePath(path);
        }
        return Resources.readBytes(path);
    }

    protected byte[] forCompiledPath(CompiledPath compiledPath) throws IOException {
        Path path = compiledPath.getPath();
        if (ContentTypes.support_templating(path)) {
            return this.forTemplatePath(path);
        }
        return compiledPath.compile().toBytes();
    }

    protected byte[] forTemplatePath(Path path) {
        return this.forModelAndView(ModelAndView.of(Resources.toUnixString(path)));
    }
}

