/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Consumer;
import net.codestory.http.io.FileVisitor;

class FolderWatcher {
    private final Path folder;
    private final Consumer<WatchEvent<?>> action;
    private boolean started;

    FolderWatcher(Path folder, Consumer<WatchEvent<?>> action) {
        this.folder = folder;
        this.action = action;
    }

    public void ensureStarted() {
        if (this.started) {
            return;
        }
        if (!this.folder.toFile().exists()) {
            return;
        }
        WatchService watcher = this.createWatcher();
        new Thread(() -> this.onChange(watcher)).start();
        this.started = true;
    }

    private WatchService createWatcher() {
        try {
            WatchService watcher = this.folder.getFileSystem().newWatchService();
            Files.walkFileTree(this.folder, FileVisitor.onDirectory(dir -> dir.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH)));
            return watcher;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to watch folder " + this.folder);
        }
    }

    private void onChange(WatchService watcher) {
        while (true) {
            try {
                while (true) {
                    WatchKey take = watcher.take();
                    take.pollEvents().forEach(this.action);
                    take.reset();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

