/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.codestory.http.Configuration;
import net.codestory.http.Context;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.errors.ErrorPage;
import net.codestory.http.errors.HttpException;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.NamedDaemonThreadFactory;
import net.codestory.http.payload.Payload;
import net.codestory.http.payload.PayloadWriter;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.Site;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebServer {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractWebServer.class);
    protected final Env env = this.createEnv();
    protected final CompilerFacade compilers = this.createCompilerFacade();
    protected final ExecutorService executorService = this.createExecutorService();
    protected RoutesProvider routesProvider;

    protected AbstractWebServer() {
    }

    protected AbstractWebServer configure(Configuration configuration) {
        this.routesProvider = this.env.prodMode() ? RoutesProvider.fixed(this.env, this.compilers, configuration) : RoutesProvider.reloading(this.env, this.compilers, configuration);
        return this;
    }

    protected void handle(Request request, Response response) {
        try {
            RouteCollection routes = this.routesProvider.get();
            Context context = routes.createContext(request, response);
            Payload payload = routes.apply(context);
            if (payload.isError()) {
                payload = this.errorPage(payload);
            }
            PayloadWriter payloadWriter = routes.createPayloadWriter(request, response, this.executorService);
            payloadWriter.writeAndClose(payload);
        }
        catch (Exception e) {
            PayloadWriter payloadWriter = new PayloadWriter(request, response, this.env, new Site(this.env), this.compilers, this.executorService);
            this.handleServerError(payloadWriter, e);
        }
    }

    protected void handleServerError(PayloadWriter payloadWriter, Exception e) {
        try {
            if (e instanceof CompilerException) {
                LOG.error(e.getMessage());
            } else if (!(e instanceof HttpException) && !(e instanceof NoSuchElementException)) {
                e.printStackTrace();
            }
            Payload errorPage = this.errorPage(e).withHeader("reason", e.getMessage());
            payloadWriter.writeAndClose(errorPage);
        }
        catch (IOException error) {
            LOG.warn("Unable to serve an error page", (Throwable)error);
        }
    }

    protected Payload errorPage(Payload payload) {
        return this.errorPage(payload, null);
    }

    protected Payload errorPage(Exception e) {
        int code = 500;
        if (e instanceof HttpException) {
            code = ((HttpException)e).code();
        } else if (e instanceof NoSuchElementException) {
            code = 404;
        }
        return this.errorPage(new Payload(code), e);
    }

    protected Payload errorPage(Payload payload, Exception e) {
        Exception shownError = this.env.prodMode() ? null : e;
        return new ErrorPage(payload, shownError).payload();
    }

    protected Env createEnv() {
        return new Env();
    }

    protected CompilerFacade createCompilerFacade() {
        Compilers compilers = new Compilers(this.env);
        HandlebarsCompiler handlebar = new HandlebarsCompiler(compilers);
        return new CompilerFacade(compilers, handlebar);
    }

    protected ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool(new NamedDaemonThreadFactory());
    }
}

