/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.function.Supplier;
import net.codestory.http.compilers.CacheEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCache {
    private static final Logger LOG = LoggerFactory.getLogger(DiskCache.class);
    private final File root;

    public DiskCache(String version, boolean prodMode) {
        this.root = Paths.get(System.getProperty("user.home"), ".code-story", "cache", version, prodMode ? "prod" : "dev").toFile();
        LOG.debug("Caching on disk @ {}", (Object)this.root.getAbsolutePath());
        System.out.println("Caching on disk @ " + this.root.getAbsolutePath());
    }

    CacheEntry computeIfAbsent(String sha1, String extension, Supplier<String> toCompiled) {
        File file = new File(new File(this.root, extension.substring(1)), sha1);
        if (file.exists()) {
            try {
                return CacheEntry.fromFile(file);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String compiled = toCompiled.get();
        try {
            DiskCache.writeToCache(file, compiled);
            return CacheEntry.fromString(compiled);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void writeToCache(File file, String data) throws IOException {
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IllegalStateException("Unable to create cache folder: " + parentFile);
        }
        File tmpFile = new File(file.getAbsolutePath() + ".tmp");
        try (FileWriter writer = new FileWriter(file);){
            writer.write(data);
        }
        tmpFile.renameTo(file);
    }
}

