/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.misc.Env;
import net.codestory.http.templating.HandlebarsCompiler;

public class CompilerFacade {
    protected final Compilers compilers;
    protected final HandlebarsCompiler handlebars;

    public CompilerFacade(Env env) {
        this.compilers = new Compilers(env);
        this.handlebars = new HandlebarsCompiler(this.compilers);
    }

    public CompilerFacade(Compilers compilers, HandlebarsCompiler handlebar) {
        this.compilers = compilers;
        this.handlebars = handlebar;
    }

    public void configureHandlebars(Consumer<Handlebars> action) {
        this.handlebars.configure(action);
    }

    public void addHandlebarResolver(ValueResolver resolver) {
        this.handlebars.addResolver(resolver);
    }

    public void registerCompiler(Supplier<Compiler> compilerFactory, String targetExtension, String firstExtension, String ... moreExtensions) {
        this.compilers.register(compilerFactory, targetExtension, firstExtension, moreExtensions);
    }

    public boolean canCompile(String extension) {
        return this.compilers.canCompile(extension);
    }

    public Set<String> extensionsThatCompileTo(String extension) {
        return this.compilers.extensionsThatCompileTo(extension);
    }

    public CacheEntry compile(Path path, String content) {
        return this.compilers.compile(path, content);
    }

    public String handlebar(String template, Map<String, ?> variables) throws IOException {
        return this.handlebars.compile(template, variables);
    }
}

