/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.annotations;

import java.lang.reflect.Method;
import net.codestory.http.annotations.Delete;
import net.codestory.http.annotations.Get;
import net.codestory.http.annotations.Head;
import net.codestory.http.annotations.Options;
import net.codestory.http.annotations.Post;
import net.codestory.http.annotations.Prefix;
import net.codestory.http.annotations.Put;
import net.codestory.http.misc.ForEach;
import net.codestory.http.misc.UrlConcat;

public class AnnotationHelper {
    private AnnotationHelper() {
    }

    public static void parseAnnotations(String urlPrefix, Class<?> type, MethodAnnotationCallback callbask) {
        Prefix prefixAnnotation;
        if (type.getName().contains("EnhancerByMockito")) {
            type = type.getSuperclass();
        }
        String classPrefix = (prefixAnnotation = type.getAnnotation(Prefix.class)) != null ? prefixAnnotation.value() : "";
        for (Method method : type.getMethods()) {
            ForEach.forEach(method.getAnnotationsByType(Get.class)).then(get -> callbask.onMethod("GET", AnnotationHelper.url(urlPrefix, classPrefix, get.value()), method));
            ForEach.forEach(method.getAnnotationsByType(Post.class)).then(post -> callbask.onMethod("POST", AnnotationHelper.url(urlPrefix, classPrefix, post.value()), method));
            ForEach.forEach(method.getAnnotationsByType(Put.class)).then(put -> callbask.onMethod("PUT", AnnotationHelper.url(urlPrefix, classPrefix, put.value()), method));
            ForEach.forEach(method.getAnnotationsByType(Delete.class)).then(delete -> callbask.onMethod("DELETE", AnnotationHelper.url(urlPrefix, classPrefix, delete.value()), method));
            ForEach.forEach(method.getAnnotationsByType(Head.class)).then(head -> callbask.onMethod("HEAD", AnnotationHelper.url(urlPrefix, classPrefix, head.value()), method));
            ForEach.forEach(method.getAnnotationsByType(Options.class)).then(options -> callbask.onMethod("OPTIONS", AnnotationHelper.url(urlPrefix, classPrefix, options.value()), method));
        }
    }

    static String url(String resourcePrefix, String classPrefix, String uri) {
        return new UrlConcat().url(resourcePrefix, classPrefix, uri);
    }

    public static interface MethodAnnotationCallback {
        public void onMethod(String var1, String var2, Method var3);
    }
}

