/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import net.codestory.http.Context;
import net.codestory.http.compilers.CompiledPath;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Cache;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;

class StaticRoute
implements Route {
    private static final Path NOT_FOUND = Paths.get("", new String[0]);
    private final Function<String, Object> findPath;

    StaticRoute(boolean cached) {
        this.findPath = cached ? new Cache<String, Object>(StaticRoute::findPath) : StaticRoute::findPath;
    }

    @Override
    public boolean matchUri(String uri) {
        return this.findPath.apply(uri) != NOT_FOUND;
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Object body(Context context) {
        String uri = context.uri();
        return this.findPath.apply(uri);
    }

    private static Object findPath(String uri) {
        Path path = Resources.findExistingPath(uri);
        if (StaticRoute.pathDoesNotExist(path)) {
            return StaticRoute.findFileCompilableToPath(uri);
        }
        return ContentTypes.is_binary(path) ? path : new CompiledPath(path, path);
    }

    private static Object findFileCompilableToPath(String uri) {
        if (uri.endsWith(".js")) {
            return StaticRoute.findPath(Strings.replaceLast(uri, ".js", ".coffee"));
        }
        if (uri.endsWith(".css")) {
            return StaticRoute.findPath(Strings.replaceLast(uri, ".css", ".less"));
        }
        return NOT_FOUND;
    }

    private static boolean pathDoesNotExist(Path path) {
        return path == null || !Resources.isPublic(path);
    }
}

