/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.Context;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.routes.Route;

public class SourceRoute
implements Route {
    private static final Path NOT_FOUND = Paths.get("", new String[0]);

    @Override
    public boolean matchUri(String uri) {
        return uri.endsWith(".source") && Resources.isPublic(this.findPath(uri, SourceRoute.getSourcePath(uri)));
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Object body(Context context) {
        String sourceUri = SourceRoute.getSourcePath(context.uri());
        return this.findPath(context.uri(), sourceUri);
    }

    public Path findPath(String uri, String sourceUri) {
        Path sourcePath = Resources.findExistingPath(sourceUri);
        if (sourcePath != null && Resources.isPublic(sourcePath)) {
            return sourcePath;
        }
        if (uri.endsWith(".js.source")) {
            String newUri = Strings.replaceLast(uri, ".js", ".coffee");
            return this.findPath(newUri, SourceRoute.getSourcePath(newUri));
        }
        if (uri.endsWith(".css.source")) {
            String newUri = Strings.replaceLast(uri, ".css", ".less");
            return this.findPath(newUri, SourceRoute.getSourcePath(newUri));
        }
        return NOT_FOUND;
    }

    private static String getSourcePath(String uri) {
        return Strings.substringBeforeLast(uri, ".source");
    }
}

