/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.NoSuchElementException;
import net.codestory.http.Configuration;
import net.codestory.http.Context;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.errors.ErrorPage;
import net.codestory.http.errors.HttpException;
import net.codestory.http.misc.Env;
import net.codestory.http.payload.Payload;
import net.codestory.http.payload.PayloadWriter;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.Site;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebServer {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractWebServer.class);
    protected final Env env = this.createEnv();
    protected final CompilerFacade compilerFacade = this.createCompilerFacade(this.env);
    protected RoutesProvider routesProvider;

    protected AbstractWebServer() {
        TypeConvert.configureMapper(mapper -> this.configureObjectMapper((ObjectMapper)mapper));
    }

    public AbstractWebServer configure(Configuration configuration) {
        this.routesProvider = this.env.prodMode() ? RoutesProvider.fixed(this.env, configuration) : RoutesProvider.reloading(this.env, configuration);
        return this;
    }

    protected void handle(Request request, Response response) {
        try {
            RouteCollection routes = this.routesProvider.get();
            Context context = this.createContext(request, response, routes);
            Payload payload = routes.apply(context);
            if (payload.isError()) {
                payload = this.errorPage(payload);
            }
            PayloadWriter payloadWriter = this.createPayloadWriter(request, response, this.env, routes.site(), this.compilerFacade);
            payloadWriter.writeAndClose(payload);
        }
        catch (Exception e) {
            PayloadWriter payloadWriter = this.createPayloadWriter(request, response, this.env, new Site(this.env), this.compilerFacade);
            this.handleServerError(payloadWriter, e);
        }
    }

    protected void handleServerError(PayloadWriter payloadWriter, Exception e) {
        try {
            if (e instanceof CompilerException) {
                LOG.error(e.getMessage());
            } else if (!(e instanceof HttpException) && !(e instanceof NoSuchElementException)) {
                e.printStackTrace();
            }
            Payload errorPage = this.errorPage(e).withHeader("reason", e.getMessage());
            payloadWriter.writeAndClose(errorPage);
        }
        catch (IOException error) {
            LOG.warn("Unable to serve an error page", (Throwable)error);
        }
    }

    protected Payload errorPage(Payload payload) {
        return this.errorPage(payload, null);
    }

    protected Payload errorPage(Exception e) {
        int code = 500;
        if (e instanceof HttpException) {
            code = ((HttpException)e).code();
        } else if (e instanceof NoSuchElementException) {
            code = 404;
        }
        return this.errorPage(new Payload(code), e);
    }

    protected Payload errorPage(Payload payload, Exception e) {
        Exception shownError = this.env.prodMode() ? null : e;
        return new ErrorPage(payload, shownError).payload();
    }

    protected void configureObjectMapper(ObjectMapper objectMapper) {
    }

    protected Env createEnv() {
        return new Env();
    }

    protected HandlebarsCompiler createHandlebarsCompiler(Compilers compilers) {
        return new HandlebarsCompiler(compilers);
    }

    protected Compilers createCompilers(Env env) {
        return new Compilers(env);
    }

    protected CompilerFacade createCompilerFacade(Env env) {
        Compilers compilers = this.createCompilers(env);
        HandlebarsCompiler handlebar = this.createHandlebarsCompiler(compilers);
        return new CompilerFacade(compilers, handlebar);
    }

    protected PayloadWriter createPayloadWriter(Request request, Response response, Env env, Site site, CompilerFacade compilerFacade) {
        return new PayloadWriter(env, site, compilerFacade, request, response);
    }

    protected Context createContext(Request request, Response response, RouteCollection routes) {
        return new Context(request, response, routes.iocAdapter(), routes.site());
    }
}

