/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.nio.file.Path;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.compilers.PathSource;
import net.codestory.http.misc.Env;

public class LessCompiler
implements Compiler {
    @Override
    public String compile(Path path, String source) {
        try {
            LessCompiler.Configuration configuration = new LessCompiler.Configuration();
            this.configureSourceMap(configuration);
            return new ThreadUnsafeLessCompiler().compile((LessSource)new PathSource(path, source), configuration).getCss();
        }
        catch (Less4jException e) {
            String message = LessCompiler.cleanMessage(path, e.getMessage());
            throw new CompilerException(message);
        }
    }

    private void configureSourceMap(LessCompiler.Configuration configuration) {
        LessCompiler.SourceMapConfiguration sourceMaps = configuration.getSourceMapConfiguration();
        sourceMaps.setLinkSourceMap(false);
        sourceMaps.setInline(!Env.get().prodMode());
    }

    private static String cleanMessage(Path path, String message) {
        return "Unable to compile less " + path + ": " + message.replace("Could not compile less. ", "");
    }
}

