/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

import java.nio.file.Path;
import net.codestory.http.io.Resources;

public class Env {
    private static Env instance = new Env();
    private final boolean prodMode;
    private final boolean disableClassPath;
    private final boolean disableFilesystem;
    private final boolean disableGzip;

    private Env() {
        this.prodMode = Env.getBoolean("PROD_MODE", false);
        this.disableClassPath = Env.getBoolean("http.disable.classpath", false);
        this.disableFilesystem = Env.getBoolean("http.disable.filesystem", false);
        this.disableGzip = Env.getBoolean("http.disable.gzip", false);
    }

    private Env(boolean prodMode, boolean disableClassPath, boolean disableFilesystem, boolean disableGzip) {
        this.prodMode = prodMode;
        this.disableClassPath = disableClassPath;
        this.disableFilesystem = disableFilesystem;
        this.disableGzip = disableGzip;
    }

    public static Env get() {
        return instance;
    }

    public static void setForTests(boolean prodMode, boolean disableClassPath, boolean disableFilesystem, boolean disableGzip) {
        instance = new Env(prodMode, disableClassPath, disableFilesystem, disableGzip);
    }

    public static void resetForTests() {
        instance = new Env();
    }

    public Path appPath() {
        return Resources.appPath();
    }

    public boolean prodMode() {
        return this.prodMode;
    }

    public int overriddenPort(int port) {
        return Env.getInt("PORT", Env.getInt("app.port", port));
    }

    public boolean disableClassPath() {
        return this.disableClassPath;
    }

    public boolean disableFilesystem() {
        return this.disableFilesystem;
    }

    public boolean disableGzip() {
        return this.disableGzip;
    }

    private static String get(String propertyName) {
        String env = System.getenv(propertyName);
        return env != null ? env : System.getProperty(propertyName);
    }

    private static boolean getBoolean(String propertyName, boolean defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private static int getInt(String propertyName, int defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Integer.parseInt(value);
    }
}

