/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import com.github.jknack.handlebars.ValueResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.io.ClasspathScanner;
import net.codestory.http.io.FileVisitor;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.MemoizingSupplier;
import net.codestory.http.templating.yaml.YamlFrontMatter;
import net.codestory.http.templating.yaml.YamlParser;

public class Site {
    private final Resources resources;
    private final Supplier<Set<String>> resourceList;
    private final Supplier<Map<String, Object>> yaml;
    private final Supplier<Map<String, Object>> data;
    private final Supplier<List<Map<String, Object>>> pages;
    private final Supplier<Map<String, List<Map<String, Object>>>> tags;
    private final Supplier<Map<String, List<Map<String, Object>>>> categories;

    public Site(Env env, Resources resources) {
        this.resources = resources;
        this.resourceList = MemoizingSupplier.memoize(() -> Site.list(env));
        this.yaml = MemoizingSupplier.memoize(() -> this.loadYamlConfig("_config.yml"));
        this.data = MemoizingSupplier.memoize(() -> this.getResourceList().stream().filter(path -> path.startsWith("_data/")).collect(Collectors.toMap(Site::nameWithoutExtension, this::readYaml)));
        this.pages = MemoizingSupplier.memoize(() -> this.getResourceList().stream().filter(path -> !path.startsWith("_")).map(this::pathToMap).collect(Collectors.toList()));
        this.tags = MemoizingSupplier.memoize(() -> {
            TreeMap<String, List> pagesPerTag = new TreeMap<String, List>();
            for (Map<String, Object> page : this.getPages()) {
                for (String tag : Site.tags(page)) {
                    pagesPerTag.computeIfAbsent(tag, key -> new ArrayList()).add(page);
                }
            }
            return pagesPerTag;
        });
        this.categories = MemoizingSupplier.memoize(() -> this.getPages().stream().collect(Collectors.groupingBy(Site::category, TreeMap::new, Collectors.toList())));
    }

    private static Set<String> list(Env env) {
        TreeSet<String> paths = new TreeSet<String>();
        try {
            Path rootPath;
            if (env.classPath()) {
                rootPath = Paths.get(env.appFolder(), new String[0]);
                new ClasspathScanner().getResources(env.appFolder()).forEach(resource -> paths.add(Resources.relativePath(rootPath, Paths.get(resource, new String[0]))));
            }
            if (env.filesystem()) {
                rootPath = new File(env.workingDir(), env.appFolder()).toPath();
                Files.walkFileTree(rootPath, FileVisitor.onFile(path -> paths.add(Resources.relativePath(rootPath, path))));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        paths.remove("");
        return paths;
    }

    private Map<String, Object> configYaml() {
        return this.yaml.get();
    }

    public Set<String> getResourceList() {
        return this.resourceList.get();
    }

    public Object get(String key) {
        return this.yaml.get().get(key);
    }

    public <T> T getAs(String key, Class<T> type) {
        return TypeConvert.convertValue(this.get(key), type);
    }

    public Map<String, Object> getData() {
        return this.data.get();
    }

    public List<Map<String, Object>> getPages() {
        return this.pages.get();
    }

    public Map<String, List<Map<String, Object>>> getTags() {
        return this.tags.get();
    }

    public Map<String, List<Map<String, Object>>> getCategories() {
        return this.categories.get();
    }

    private Map<String, Object> pathToMap(String path) {
        try {
            Path yamlPath = Paths.get(path, new String[0]);
            return YamlFrontMatter.parse(this.resources.sourceFile(yamlPath)).getVariables();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read file: " + path, e);
        }
    }

    private Object readYaml(String path) {
        try {
            return YamlParser.INSTANCE.parse(this.resources.sourceFile(Paths.get(path, new String[0])));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read file: " + path, e);
        }
    }

    private static String category(Map<String, Object> page) {
        return page.getOrDefault("category", "").toString().trim();
    }

    private static String[] tags(Map<String, Object> page) {
        Object tags = page.getOrDefault("tags", "");
        if (tags instanceof List) {
            return (String[])((List)tags).stream().toArray(String[]::new);
        }
        return tags.toString().trim().split("\\s*,\\s*");
    }

    private Map<String, Object> loadYamlConfig(String configFile) {
        Path configPath = Paths.get(configFile, new String[0]);
        if (!this.resources.exists(configPath)) {
            return Collections.emptyMap();
        }
        try {
            return YamlParser.INSTANCE.parseMap(this.resources.sourceFile(configPath));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read " + configFile, e);
        }
    }

    private static String nameWithoutExtension(String path) {
        return Strings.substringBeforeLast(Paths.get(path, new String[0]).getFileName().toString(), ".");
    }

    static enum SiteValueResolver implements ValueResolver
    {
        INSTANCE;


        public Object resolve(Object context, String name) {
            if (context instanceof Site) {
                return ((Site)context).configYaml().getOrDefault(name, UNRESOLVED);
            }
            return UNRESOLVED;
        }

        public Object resolve(Object o) {
            return UNRESOLVED;
        }

        public Set<Map.Entry<String, Object>> propertySet(Object context) {
            if (context instanceof Site) {
                return ((Site)context).configYaml().entrySet();
            }
            return Collections.emptySet();
        }
    }
}

