/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.util.Objects;
import net.codestory.http.Query;
import net.codestory.http.io.Strings;

public class UriParser
implements Comparable<UriParser> {
    private final String uriPattern;
    private final String[] patternParts;
    private final String[] queryParamsParts;
    private final int paramsCount;

    public UriParser(String uriPattern) {
        this.uriPattern = uriPattern;
        this.patternParts = UriParser.parts(UriParser.stripQueryParams(uriPattern));
        this.queryParamsParts = UriParser.queryParamsParts(UriParser.extractQueryParams(uriPattern));
        this.paramsCount = UriParser.paramsCount(uriPattern);
    }

    public String uriPattern() {
        return this.uriPattern;
    }

    public String[] params(String uri, Query query) {
        int i;
        String[] uriParts = UriParser.parts(uri);
        String[] params = new String[this.paramsCount];
        int index = 0;
        for (i = 0; i < uriParts.length; ++i) {
            if (!this.patternParts[i].startsWith(":")) continue;
            params[index++] = uriParts[i];
        }
        for (i = 0; i < this.queryParamsParts.length; ++i) {
            if (!this.queryParamsParts[i].startsWith(":")) continue;
            params[index++] = query.get(this.queryParamsParts[i - 1]);
        }
        return params;
    }

    public boolean matches(String uri) {
        String[] uriParts = UriParser.parts(UriParser.stripQueryParams(uri));
        if (this.patternParts.length != uriParts.length) {
            return false;
        }
        for (int i = 0; i < this.patternParts.length; ++i) {
            if (this.patternParts[i].startsWith(":") || this.patternParts[i].equals(uriParts[i])) continue;
            return false;
        }
        int lastPart = this.patternParts.length - 1;
        return !this.patternParts[lastPart].startsWith(":") || !uriParts[lastPart].isEmpty();
    }

    private static String[] parts(String uri) {
        return uri.split("/", -1);
    }

    private static String[] queryParamsParts(String uri) {
        return uri.split("[=&]", -1);
    }

    static String stripQueryParams(String uri) {
        int indexSlash = uri.indexOf(63);
        return indexSlash == -1 ? uri : uri.substring(0, indexSlash);
    }

    static String extractQueryParams(String uri) {
        int indexSlash = uri.indexOf(63);
        return indexSlash == -1 ? "" : uri.substring(indexSlash + 1);
    }

    public static int paramsCount(String uriPattern) {
        return Strings.countMatches(uriPattern, ':');
    }

    public boolean equals(Object obj) {
        if (obj instanceof UriParser) {
            UriParser other = (UriParser)obj;
            return Objects.equals(this.uriPattern, other.uriPattern);
        }
        return false;
    }

    public int hashCode() {
        return this.uriPattern.hashCode();
    }

    @Override
    public int compareTo(UriParser other) {
        int compare = Integer.compare(this.paramsCount, other.paramsCount);
        if (compare != 0) {
            return compare;
        }
        int index = 0;
        for (String part : this.patternParts) {
            boolean hasPart1ADash = part.startsWith(":");
            boolean hasPart2ADash = other.patternParts[index].startsWith(":");
            if (hasPart1ADash && !hasPart2ADash) {
                return 1;
            }
            if (hasPart2ADash && !hasPart1ADash) {
                return -1;
            }
            if (other.patternParts.length != ++index) continue;
            return 0;
        }
        return 0;
    }
}

